/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.httpclient.NettyHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.WebClientPlugin;
import org.apache.shenyu.plugin.httpclient.config.HttpClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.DefaultSslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

@Configuration
public class HttpClientPluginConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.httpclient")
    public HttpClientProperties httpClientProperties() {
        return new HttpClientProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.httpclient.thread-pool.prefix"})
    public LoopResources httpClientLoopResource(HttpClientProperties properties) {
        HttpClientProperties.ThreadPool threadPool = properties.getThreadPool();
        return LoopResources.create((String)threadPool.getPrefix(), (int)threadPool.getSelectCount(), (int)threadPool.getWorkerCount(), (boolean)threadPool.getDaemon());
    }

    @Bean
    public HttpClient httpClient(HttpClientProperties properties, ObjectProvider<LoopResources> provider) {
        HttpClientProperties.Ssl ssl;
        HttpClientProperties.Pool pool = properties.getPool();
        ConnectionProvider connectionProvider = this.buildConnectionProvider(pool);
        HttpClient httpClient = (HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)properties.getConnectTimeout());
        HttpClientProperties.Proxy proxy = properties.getProxy();
        if (StringUtils.isNotEmpty((CharSequence)proxy.getHost())) {
            httpClient = this.setHttpClientProxy(httpClient, proxy);
        }
        httpClient.doOnConnected(connection -> {
            connection.addHandlerLast((ChannelHandler)new IdleStateHandler((long)properties.getReaderIdleTime().intValue(), (long)properties.getWriterIdleTime().intValue(), (long)properties.getAllIdleTime().intValue(), TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)properties.getWriteTimeout().intValue(), TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)properties.getReadTimeout().intValue(), TimeUnit.MILLISECONDS));
        });
        LoopResources loopResources = (LoopResources)provider.getIfAvailable();
        if (Objects.nonNull(loopResources)) {
            httpClient.runOn(loopResources);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ssl = properties.getSsl()).getKeyStorePath()) || ArrayUtils.isNotEmpty((Object[])ssl.getTrustedX509CertificatesForTrustManager()) || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> this.setSsl((SslProvider.SslContextSpec)sslContextSpec, ssl));
        }
        if (properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        return httpClient.keepAlive(properties.isKeepAlive());
    }

    private HttpClient setHttpClientProxy(HttpClient httpClient, HttpClientProperties.Proxy proxy) {
        return (HttpClient)httpClient.proxy(proxySpec -> {
            ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxy.getHost());
            PropertyMapper map = PropertyMapper.get();
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getPort()).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getUsername()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getPassword()).whenHasText().to(password -> builder.password(s -> password));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getNonProxyHostsPattern()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
        });
    }

    private void setSsl(SslProvider.SslContextSpec sslContextSpec, HttpClientProperties.Ssl ssl) {
        AbstractProtocolSslContextSpec spec = DefaultSslContextSpec.forClient().configure(sslContextBuilder -> {
            Object[] trustedX509Certificates = ssl.getTrustedX509CertificatesForTrustManager();
            if (ArrayUtils.isNotEmpty((Object[])trustedX509Certificates)) {
                sslContextBuilder.trustManager((X509Certificate[])trustedX509Certificates);
            } else if (ssl.isUseInsecureTrustManager()) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            sslContextBuilder.keyManager(ssl.getKeyManagerFactory());
            sslContextBuilder.sslProvider(ssl.getDefaultConfigurationType());
        });
        sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)spec).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
    }

    private ConnectionProvider buildConnectionProvider(HttpClientProperties.Pool pool) {
        ConnectionProvider connectionProvider = pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED ? ConnectionProvider.newConnection() : (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED ? HttpClientPluginConfiguration.buildFixedConnectionPool(pool) : this.buildElasticConnectionPool(pool));
        return connectionProvider;
    }

    public static ConnectionProvider buildFixedConnectionPool(HttpClientProperties.Pool pool) {
        if (pool.getMaxConnections() <= 0) {
            throw new IllegalArgumentException("Max Connections value must be strictly positive");
        }
        if (pool.getAcquireTimeout() < 0L) {
            throw new IllegalArgumentException("Acquire Timeout value must be positive");
        }
        ConnectionProvider.Builder builder = (ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)pool.getName()).maxConnections(pool.getMaxConnections().intValue())).pendingAcquireTimeout(Duration.ofMillis(pool.getAcquireTimeout()))).maxIdleTime(pool.getMaxIdleTime());
        return builder.build();
    }

    public ConnectionProvider buildElasticConnectionPool(HttpClientProperties.Pool pool) {
        ConnectionProvider.Builder builder = (ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)pool.getName()).maxConnections(Integer.MAX_VALUE)).pendingAcquireTimeout(Duration.ofMillis(0L))).pendingAcquireMaxCount(-1)).maxIdleTime(pool.getMaxIdleTime());
        return builder.build();
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="netty")
    static class NettyHttpClientConfiguration {
        NettyHttpClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin nettyHttpClientPlugin(ObjectProvider<HttpClient> httpClient) {
            return new NettyHttpClientPlugin((HttpClient)httpClient.getIfAvailable());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="webClient", matchIfMissing=true)
    static class WebClientConfiguration {
        WebClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin webClientPlugin(HttpClientProperties properties, ObjectProvider<HttpClient> httpClient) {
            WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(properties.getMaxInMemorySize() * 1024 * 1024)).build()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)Objects.requireNonNull(httpClient.getIfAvailable()))).build();
            return new WebClientPlugin(webClient);
        }
    }
}

