/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.service;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.AuthParamData;
import org.apache.shenyu.common.dto.AuthPathData;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.base.utils.PathMatchUtils;
import org.apache.shenyu.plugin.sign.api.SignParameters;
import org.apache.shenyu.plugin.sign.api.VerifyResult;
import org.apache.shenyu.plugin.sign.api.VerifySupplier;
import org.apache.shenyu.plugin.sign.cache.SignAuthDataCache;
import org.apache.shenyu.plugin.sign.extractor.SignParameterExtractor;
import org.apache.shenyu.plugin.sign.provider.SignProvider;
import org.apache.shenyu.plugin.sign.service.SignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class ComposableSignService
implements SignService {
    private static final Logger LOG = LoggerFactory.getLogger(ComposableSignService.class);
    @Value(value="${shenyu.sign.delay:5}")
    private int delay;
    private final SignParameterExtractor extractor;
    private final SignProvider signProvider;

    public ComposableSignService(SignParameterExtractor extractor, SignProvider signProvider) {
        this.extractor = extractor;
        this.signProvider = signProvider;
    }

    @Override
    public VerifyResult signatureVerify(ServerWebExchange exchange, String requestBody) {
        return this.signatureVerify(exchange, (String signKey, SignParameters signParameters) -> this.signProvider.generateSign((String)signKey, (SignParameters)signParameters, requestBody));
    }

    @Override
    public VerifyResult signatureVerify(ServerWebExchange exchange) {
        return this.signatureVerify(exchange, this.signProvider::generateSign);
    }

    private VerifyResult signatureVerify(ServerWebExchange exchange, BiFunction<String, SignParameters, String> signFunction) {
        AppAuthData appAuthData;
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        SignParameters signParameters = this.extractor.extract((HttpRequest)exchange.getRequest());
        VerifyResult result = this.verify(signParameters, appAuthData = (AppAuthData)Optional.ofNullable(signParameters.getAppKey()).map(key -> SignAuthDataCache.getInstance().obtainAuthData((String)key)).orElse(null), signFunction);
        if (result.isSuccess()) {
            this.handleExchange(exchange, appAuthData, shenyuContext.getContextPath());
        }
        return result;
    }

    private VerifyResult verify(SignParameters signParameters, AppAuthData appAuthData, BiFunction<String, SignParameters, String> signFunction) {
        return VerifySupplier.apply(() -> this.verifySignParameters(signParameters)).and(() -> this.verifyExpires(signParameters)).and(() -> this.verifyAuthConfig(appAuthData, signParameters)).and(() -> this.verifyPath(appAuthData, signParameters)).and(() -> this.verifySign(appAuthData.getAppSecret(), signParameters, signFunction)).verify();
    }

    private VerifyResult verifyPath(AppAuthData appAuthData, SignParameters signParameters) {
        if (BooleanUtils.isNotTrue((Boolean)appAuthData.getOpen())) {
            return VerifyResult.success();
        }
        List pathDataList = appAuthData.getPathDataList();
        if (CollectionUtils.isEmpty((Collection)pathDataList)) {
            LOG.error("You have not configured the sign path:{}", (Object)signParameters.getAppKey());
            return VerifyResult.fail("you have not configured the sign path.");
        }
        boolean match = pathDataList.stream().filter(AuthPathData::getEnabled).anyMatch(e -> PathMatchUtils.match((String)e.getPath(), (String)signParameters.getUri().getPath()));
        if (!match) {
            LOG.error("You have not configured the sign path:{},{}", (Object)signParameters.getAppKey(), (Object)signParameters.getUri().getPath());
            return VerifyResult.fail("you have not configured the sign path.");
        }
        return VerifyResult.success();
    }

    private VerifyResult verifyAuthConfig(AppAuthData appAuthData, SignParameters signParameters) {
        if (Objects.isNull(appAuthData) || BooleanUtils.isFalse((Boolean)appAuthData.getEnabled())) {
            LOG.error("sign APP_KEY does not exist or has been disabled,{}", (Object)signParameters.getAppKey());
            return VerifyResult.fail("sign appKey does not exist.");
        }
        return VerifyResult.success();
    }

    private VerifyResult verifySignParameters(SignParameters signParameters) {
        boolean success;
        if (signParameters == SignParameters.VERSION_ERROR_PARAMETERS) {
            LOG.error("sign version does not exist or is wrong");
            return VerifyResult.fail("sign version does not exist or is wrong!");
        }
        boolean bl = success = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{signParameters.getAppKey()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{signParameters.getTimestamp()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{signParameters.getSignature()});
        if (success) {
            return VerifyResult.success();
        }
        LOG.error("sign parameters are incomplete,{}", (Object)signParameters);
        return VerifyResult.fail("sign parameters are incomplete!");
    }

    private VerifyResult verifyExpires(SignParameters signParameters) {
        LocalDateTime now;
        LocalDateTime start = DateUtils.formatLocalDateTimeFromTimestampBySystemTimezone((Long)Long.parseLong(signParameters.getTimestamp()));
        long between = DateUtils.acquireMinutesBetween((LocalDateTime)start, (LocalDateTime)(now = LocalDateTime.now()));
        if (Math.abs(between) <= (long)this.delay) {
            return VerifyResult.success();
        }
        return VerifyResult.fail(String.format(ShenyuResultEnum.SIGN_TIME_IS_TIMEOUT.getMsg(), this.delay));
    }

    private VerifyResult verifySign(String signKey, SignParameters signParameters, BiFunction<String, SignParameters, String> signFunction) {
        String sign = signFunction.apply(signKey, signParameters);
        boolean result = Objects.equals(sign, signParameters.getSignature());
        if (!result) {
            LOG.error("the SignUtils generated signature value is:{},the accepted value is:{}", (Object)sign, (Object)signParameters.getSignature());
            return VerifyResult.fail("signature value is error!");
        }
        return VerifyResult.success();
    }

    private void handleExchange(ServerWebExchange exchange, AppAuthData appAuthData, String contextPath) {
        List paramDataList = appAuthData.getParamDataList();
        if (!CollectionUtils.isEmpty((Collection)paramDataList)) {
            paramDataList.stream().filter(p -> ("/" + p.getAppName()).equals(contextPath)).map(AuthParamData::getAppParam).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).findFirst().ifPresent(param -> exchange.getRequest().mutate().headers(httpHeaders -> httpHeaders.set("appParam", param)).build());
        }
    }
}

