/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.provider;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.utils.SignUtils;
import org.apache.shenyu.plugin.sign.api.SignParameters;
import org.apache.shenyu.plugin.sign.provider.SignProvider;

public class VersionTwoSignProvider
implements SignProvider {
    @Override
    public String generateSign(String signKey, SignParameters signParameters, String requestBody) {
        String data = signParameters.getParameters() + this.getRelativeURL(signParameters.getUri()) + Optional.ofNullable(requestBody).orElse("");
        return SignUtils.sign((String)signParameters.getSignAlg(), (String)signKey, (String)data).toUpperCase();
    }

    @Override
    public String generateSign(String signKey, SignParameters signParameters) {
        return this.generateSign(signKey, signParameters, null);
    }

    private String getRelativeURL(URI uri) {
        if (Objects.isNull(uri.getQuery())) {
            return uri.getPath();
        }
        return uri.getPath() + "?" + uri.getQuery();
    }
}

