/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.apache.shenyu.plugin.sign.decorator.SignRequestDecorator;
import org.apache.shenyu.plugin.sign.handler.SignPluginDataHandler;
import org.apache.shenyu.plugin.sign.handler.SignRuleHandler;
import org.reactivestreams.Publisher;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SignPlugin
extends AbstractShenyuPlugin {
    private static final List<HttpMessageReader<?>> MESSAGE_READERS = HandlerStrategies.builder().build().messageReaders();
    private final SignService signService;

    public SignPlugin(SignService signService) {
        this.signService = signService;
    }

    public String named() {
        return PluginEnum.SIGN.getName();
    }

    public int getOrder() {
        return PluginEnum.SIGN.getCode();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selectorData, RuleData rule) {
        SignRuleHandler ruleHandler = (SignRuleHandler)SignPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (!ObjectUtils.isEmpty((Object)ruleHandler) && ruleHandler.getSignRequestBody()) {
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, MESSAGE_READERS);
            Mono mono = serverRequest.bodyToMono(String.class).switchIfEmpty(Mono.defer(() -> Mono.just((Object)""))).flatMap(originalBody -> this.signBody((String)originalBody, exchange));
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)mono, String.class);
            CachedBodyOutputMessage outputMessage = ResponseUtils.newCachedBodyOutputMessage((ServerWebExchange)exchange);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                SignRequestDecorator decorator = new SignRequestDecorator(exchange, outputMessage);
                return chain.execute(exchange.mutate().request((ServerHttpRequest)decorator).build());
            })).onErrorResume(throwable -> ResponseUtils.release((CachedBodyOutputMessage)outputMessage, (Throwable)throwable));
        }
        Pair<Boolean, String> result = this.signService.signVerify(exchange);
        if (Boolean.FALSE.equals(result.getLeft())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)((String)result.getRight()), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(exchange);
    }

    private Mono signBody(String originalBody, ServerWebExchange exchange) {
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        Map<String, Object> requestBody = StringUtils.isBlank((CharSequence)originalBody) ? Maps.newHashMapWithExpectedSize((int)4) : JsonUtils.jsonToMap((String)originalBody);
        requestBody.putAll(queryParams.toSingleValueMap());
        Pair<Boolean, String> result = this.signService.signVerify(exchange, requestBody);
        if (Boolean.FALSE.equals(result.getLeft())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)((String)result.getRight()), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return Mono.just((Object)originalBody);
    }
}

