/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.mask.api.utils;

import java.util.List;
import java.util.Map;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.mask.api.factory.DataMaskFactory;
import org.apache.shenyu.plugin.logging.mask.api.matcher.KeyWordMatch;
import org.springframework.util.StringUtils;

public final class DataMaskUtils {
    public static String maskForSingleWord(String keyWord, String source, KeyWordMatch keyWordMatch, String dataMaskAlg) {
        return DataMaskUtils.maskSingleKeyword(true, keyWord, source, keyWordMatch, dataMaskAlg);
    }

    public static String maskForBody(String source, KeyWordMatch keyWordMatch, String dataMaskAlg) {
        return DataMaskUtils.maskBody(true, source, keyWordMatch, dataMaskAlg);
    }

    public static String maskSingleKeyword(boolean masked, String keyWord, String source, KeyWordMatch keyWordMatch, String dataMaskAlg) {
        if (StringUtils.hasLength((String)source) && masked && keyWordMatch.matches(keyWord)) {
            return DataMaskFactory.selectMask(source, dataMaskAlg);
        }
        return source;
    }

    public static String maskBody(boolean masked, String source, KeyWordMatch keyWordMatch, String dataMaskAlg) {
        if (StringUtils.hasLength((String)source) && masked) {
            Map bodyMap = JsonUtils.jsonToMap((String)source, String.class);
            bodyMap.forEach((key, value) -> {
                if (keyWordMatch.matches((String)key)) {
                    bodyMap.put(key, DataMaskFactory.selectMask(value, dataMaskAlg));
                }
            });
            return JsonUtils.toJson((Object)bodyMap);
        }
        return source;
    }

    public static void maskList(boolean masked, String keyword, List<String> source, KeyWordMatch keyWordMatch, String dataMaskAlg) {
        if (masked && keyWordMatch.matches(keyword)) {
            for (int i = 0; i < source.size(); ++i) {
                String ret = DataMaskFactory.selectMask(source.get(i), dataMaskAlg);
                source.set(i, ret);
            }
        }
    }
}

