/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.mask.api.spi;

import org.apache.shenyu.plugin.logging.mask.api.spi.AbstractShenyuDataMask;
import org.apache.shenyu.spi.Join;

@Join
public class CharacterReplaceDataMask
extends AbstractShenyuDataMask {
    private static final Character MASK = Character.valueOf('*');

    @Override
    protected String doMask(String source) {
        return this.maskData(source, source.length() / 2);
    }

    private String maskData(String data, int maskNum) {
        if (data.length() == 1) {
            return "*";
        }
        StringBuilder sb = new StringBuilder(data);
        int mid = data.length() / 2;
        int l = mid - 1;
        int r = mid;
        int currentMaskNum = 0;
        while (currentMaskNum < maskNum) {
            int tempMaskNum = currentMaskNum++;
            if (r < data.length()) {
                sb.setCharAt(r, MASK.charValue());
                ++r;
            }
            if (currentMaskNum >= maskNum) break;
            if (l >= 0) {
                sb.setCharAt(l, MASK.charValue());
                --l;
                ++currentMaskNum;
            }
            if (tempMaskNum != currentMaskNum) continue;
            break;
        }
        return sb.toString();
    }
}

