/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.huawei.lts.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.huaweicloud.lts.appender.JavaSDKAppender;
import com.huaweicloud.lts.producer.Producer;
import com.huaweicloud.lts.producer.Result;
import com.huaweicloud.lts.producer.exception.LogSizeTooLargeException;
import com.huaweicloud.lts.producer.exception.MaxBatchCountExceedException;
import com.huaweicloud.lts.producer.exception.ProducerException;
import com.huaweicloud.lts.producer.exception.ResultFailedException;
import com.huaweicloud.lts.producer.model.log.LogContent;
import com.huaweicloud.lts.producer.model.log.LogItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.plugin.huawei.lts.config.HuaweiLogCollectConfig;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.constant.GenericLoggingConstant;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class HuaweiLtsLogCollectClient
extends AbstractLogConsumeClient<HuaweiLogCollectConfig.HuaweiLtsLogConfig, ShenyuRequestLog> {
    private Producer producer;
    private String logGroupId;
    private String logStreamId;
    private String projectId;
    private ThreadPoolExecutor threadExecutor;

    public void initClient0(@NonNull HuaweiLogCollectConfig.HuaweiLtsLogConfig huaweiLtsLogConfig) {
        String accessKeyId = huaweiLtsLogConfig.getAccessKeyId();
        String accessKeySecret = huaweiLtsLogConfig.getAccessKeySecret();
        String regionName = huaweiLtsLogConfig.getRegionName();
        this.projectId = huaweiLtsLogConfig.getProjectId();
        this.logGroupId = huaweiLtsLogConfig.getLogGroupId();
        this.logStreamId = huaweiLtsLogConfig.getLogStreamId();
        if (StringUtils.isBlank((CharSequence)accessKeyId) || StringUtils.isBlank((CharSequence)accessKeySecret) || StringUtils.isBlank((CharSequence)this.projectId) || StringUtils.isBlank((CharSequence)regionName) || StringUtils.isBlank((CharSequence)this.logGroupId) || StringUtils.isBlank((CharSequence)this.logStreamId)) {
            LOG.error("init Huawei lts client error, please check projectId, accessKeyId, accessKeySecret, regionName, logGroupId or logStreamId");
            return;
        }
        JavaSDKAppender appender = JavaSDKAppender.custom().setProjectId(this.projectId).setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret).setRegionName(regionName).setTotalSizeInBytes(huaweiLtsLogConfig.getTotalSizeInBytes()).setMaxBlockMs(huaweiLtsLogConfig.getMaxBlockMs()).setBatchSizeThresholdInBytes(huaweiLtsLogConfig.getBatchSizeThresholdInBytes()).setBatchCountThreshold(huaweiLtsLogConfig.getBatchCountThreshold()).setLingerMs(huaweiLtsLogConfig.getLingerMs()).setRetries(huaweiLtsLogConfig.getRetries()).setBaseRetryBackoffMs(huaweiLtsLogConfig.getBaseRetryBackoffMs()).setMaxRetryBackoffMs(huaweiLtsLogConfig.getMaxRetryBackoffMs()).setEnableLocalTest(Boolean.valueOf(Boolean.parseBoolean(huaweiLtsLogConfig.getEnableLocalTest()))).setGiveUpExtraLongSingleLog(Boolean.valueOf(Boolean.parseBoolean(huaweiLtsLogConfig.getEnableLocalTest()))).builder();
        this.producer = appender.getProducer();
        this.threadExecutor = HuaweiLtsLogCollectClient.createThreadPoolExecutor(huaweiLtsLogConfig.getIoThreadCount());
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) throws Exception {
        logs.forEach(this::sendLog);
    }

    public void close0() throws Exception {
        if (Objects.nonNull(this.producer)) {
            try {
                this.producer.close();
            }
            catch (ProducerException | InterruptedException e) {
                LOG.error("Close producer error.");
            }
        }
    }

    private void sendLog(ShenyuRequestLog log) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        ArrayList<LogItem> logItemList = new ArrayList<LogItem>();
        LogItem logItem = new LogItem();
        logItem.setTenantProjectId(this.projectId);
        logItems.add(logItem);
        logItem.setLabels(JSONObject.toJSONString(new HashMap()));
        ArrayList<LogContent> contents = new ArrayList<LogContent>();
        LogContent logContent = new LogContent();
        logContent.setLogTimeNs(System.currentTimeMillis() * 1000000L + System.nanoTime() % 1000000L);
        logContent.setLog(log.toString());
        contents.add(logContent);
        logItem.setContents(contents);
        logItemList.add(logItem);
        try {
            ListenableFuture f = this.producer.send(this.logGroupId, this.logStreamId, logItemList);
            Futures.addCallback((ListenableFuture)f, (FutureCallback)new ProducerFutureCallback(this.logGroupId, this.logStreamId), (Executor)this.threadExecutor);
        }
        catch (InterruptedException e) {
            LOG.warn("The current thread has been interrupted during send logs.");
        }
        catch (ProducerException e) {
            if (e instanceof MaxBatchCountExceedException) {
                LOG.error("The logs exceeds the maximum batch count, e={}", (Object)e.getMessage());
            }
            if (e instanceof LogSizeTooLargeException) {
                LOG.error("The size of log is larger than the maximum allowable size, e={}", (Object)e.getMessage());
            }
            LOG.error("Failed to send logs, e={}", (Object)e.getMessage());
        }
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(int sendThreadCount) {
        int threadCount = sendThreadCount;
        if (threadCount > GenericLoggingConstant.MAX_ALLOW_THREADS) {
            LOG.warn("send thread count number too large!");
            threadCount = GenericLoggingConstant.MAX_ALLOW_THREADS;
        }
        return new ThreadPoolExecutor(threadCount, GenericLoggingConstant.MAX_ALLOW_THREADS, 60000L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(GenericLoggingConstant.MAX_QUEUE_NUMBER), ShenyuThreadFactory.create((String)"shenyu-huawei-lts", (boolean)true), new ThreadPoolExecutor.AbortPolicy());
    }

    private static final class ProducerFutureCallback
    implements FutureCallback<Result> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProducerFutureCallback.class);
        private final String logGroupId;
        private final String logStreamId;

        ProducerFutureCallback(String logGroupId, String logStreamId) {
            this.logGroupId = logGroupId;
            this.logStreamId = logStreamId;
        }

        public void onSuccess(@Nullable Result result) {
            LOGGER.info("Send logs to Huawei lts successfully.");
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof ResultFailedException) {
                Result result = ((ResultFailedException)throwable).getResult();
                LOGGER.error("Failed to send logs, logGroupId={}, logStreamId={}, result={}", new Object[]{this.logGroupId, this.logStreamId, result});
            } else {
                LOGGER.error("Failed to send log, e={}", (Object)throwable.getMessage());
            }
        }
    }
}

