/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.SharedResourceHolder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.grpc.loadbalance.GrpcAttributeUtils;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuResolverHelper;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstance;
import org.apache.shenyu.plugin.grpc.resolver.ShenyuServiceInstanceLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuNameResolver
extends NameResolver
implements Consumer<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuNameResolver.class);
    private boolean resolving;
    private NameResolver.Listener2 listener;
    private Executor executor;
    private final String appName;
    private final Attributes attributes;
    private final SynchronizationContext syncContext;
    private final List<ShenyuServiceInstance> keep = null;
    private List<ShenyuServiceInstance> instanceList = Lists.newArrayList();
    private final SharedResourceHolder.Resource<Executor> executorResource;

    public ShenyuNameResolver(String appName, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this.appName = appName;
        this.executor = args.getOffloadExecutor();
        this.executorResource = executorResource;
        this.attributes = Attributes.newBuilder().set(GrpcAttributeUtils.appName(), (Object)appName).build();
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        ApplicationConfigCache.getInstance().watch(this.appName, this);
        this.resolve();
    }

    @Override
    public void accept(Object o) {
        this.syncContext.execute(() -> {
            if (this.listener != null) {
                this.resolve();
            }
        });
    }

    public void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    private void resolve() {
        LOG.info("Scheduled resolve for {}", (Object)this.appName);
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener, this.instanceList));
    }

    public String getServiceAuthority() {
        return this.appName;
    }

    public void shutdown() {
        this.listener = null;
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;
        private final List<ShenyuServiceInstance> savedInstanceList;

        Resolve(NameResolver.Listener2 listener, List<ShenyuServiceInstance> instanceList) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
            this.savedInstanceList = Objects.requireNonNull(instanceList, "instanceList");
        }

        @Override
        public void run() {
            AtomicReference<List<ShenyuServiceInstance>> resultContainer = new AtomicReference<List<ShenyuServiceInstance>>();
            try {
                resultContainer.set(this.resolveInternal());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + ShenyuNameResolver.this.appName));
                resultContainer.set(Lists.newArrayList());
            }
            finally {
                ShenyuNameResolver.this.syncContext.execute(() -> {
                    ShenyuNameResolver.this.resolving = false;
                    List newInstanceList = (List)resultContainer.get();
                    if (newInstanceList != ShenyuNameResolver.this.keep && ShenyuNameResolver.this.listener != null) {
                        ShenyuNameResolver.this.instanceList = newInstanceList;
                    }
                });
            }
        }

        private List<ShenyuServiceInstance> resolveInternal() {
            String name = ShenyuNameResolver.this.appName;
            ShenyuServiceInstanceLists shenyuServiceInstanceLists = ApplicationConfigCache.getInstance().get(name);
            List<ShenyuServiceInstance> newInstanceList = shenyuServiceInstanceLists.getCopyInstances();
            LOG.info("Got {} candidate servers for {}", (Object)newInstanceList.size(), (Object)name);
            if (CollectionUtils.isEmpty(newInstanceList)) {
                LOG.info("No servers found for {}", (Object)name);
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + name));
                return Lists.newArrayList();
            }
            if (!this.needsToUpdateConnections(newInstanceList)) {
                LOG.info("Nothing has changed... skipping update for {}", (Object)name);
                return null;
            }
            LOG.info("Ready to update server list for {}", (Object)name);
            List targets = newInstanceList.stream().map(instance -> {
                LOG.info("Found gRPC server {}:{} for {}", new Object[]{instance.getHost(), instance.getPort(), name});
                return ShenyuResolverHelper.convertToEquivalentAddressGroup(instance);
            }).collect(Collectors.toList());
            this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(targets).setAttributes(ShenyuNameResolver.this.attributes).build());
            LOG.info("Done updating server list for {}", (Object)name);
            return newInstanceList;
        }

        private boolean needsToUpdateConnections(List<ShenyuServiceInstance> newInstanceList) {
            if (this.savedInstanceList.size() != newInstanceList.size()) {
                return true;
            }
            for (ShenyuServiceInstance instance : this.savedInstanceList) {
                String host = instance.getHost();
                int port = instance.getPort();
                boolean isSame = newInstanceList.stream().anyMatch(newInstance -> host.equals(newInstance.getHost()) && port == newInstance.getPort() && this.isMetadataEquals(instance.getMetadata(), newInstance.getMetadata()));
                if (isSame) continue;
                return true;
            }
            return false;
        }

        private boolean isMetadataEquals(Map<String, String> metadata, Map<String, String> newMetadata) {
            String[] keys;
            for (String key : keys = new String[]{"weight", "status"}) {
                String newValue;
                String value = metadata.get(key);
                if (Objects.equals(value, newValue = newMetadata.get(key))) continue;
                return false;
            }
            return true;
        }
    }
}

