/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.proto;

import com.google.common.collect.ImmutableList;
import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.shenyu.plugin.grpc.proto.CompleteObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeStreamObserver<T>
implements StreamObserver<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeStreamObserver.class);
    private final ImmutableList<StreamObserver<T>> observers;

    private CompositeStreamObserver(ImmutableList<StreamObserver<T>> observers) {
        this.observers = observers;
    }

    public static <T> CompositeStreamObserver<T> of(StreamObserver<T> observers, CompleteObserver<T> completeObserver) {
        return new CompositeStreamObserver<T>(ImmutableList.of(observers, completeObserver));
    }

    public void onCompleted() {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onCompleted();
            }
            catch (Exception t) {
                log.error("Exception in composite onComplete, moving on", (Throwable)t);
            }
        }
    }

    public void onError(Throwable t) {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onError(t);
            }
            catch (Exception exception) {
                log.error("Exception in composite onError, moving on", (Throwable)exception);
            }
        }
    }

    public void onNext(T value) {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onNext(value);
            }
            catch (Exception exception) {
                log.error("Exception in composite onNext, moving on", (Throwable)exception);
            }
        }
    }
}

