/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.loadbalance;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.plugin.grpc.loadbalance.GrpcAttributeUtils;
import org.apache.shenyu.plugin.grpc.loadbalance.SubChannels;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.AbstractPicker;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.AbstractReadyPicker;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.EmptyPicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoadBalancer
extends LoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLoadBalancer.class);
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");
    private final LoadBalancer.Helper helper;
    private final AtomicReference<String> serviceName = new AtomicReference();
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new ConcurrentHashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private ConnectivityState currentState;
    private AbstractPicker currentPicker = new EmptyPicker(EMPTY_OK);

    public AbstractLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    private String getServiceName() {
        return this.serviceName.get();
    }

    private void setAttribute(Attributes attributes) {
        this.serviceName.compareAndSet(null, attributes.get(GrpcAttributeUtils.appName()).toString());
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.setAttribute(resolvedAddresses.getAttributes());
        Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
        Map<EquivalentAddressGroup, EquivalentAddressGroup> latestAddrs = this.stripAttrs(resolvedAddresses.getAddresses());
        Set<EquivalentAddressGroup> removedAddrs = this.setsDifference(currentAddrs, latestAddrs.keySet());
        for (Map.Entry<EquivalentAddressGroup, EquivalentAddressGroup> latestEntry : latestAddrs.entrySet()) {
            LoadBalancer.Subchannel subchannel;
            EquivalentAddressGroup strippedAddressGroup = latestEntry.getKey();
            EquivalentAddressGroup originalAddressGroup = latestEntry.getValue();
            LoadBalancer.Subchannel existingSubchannel = this.subchannels.get(strippedAddressGroup);
            if (Objects.nonNull(existingSubchannel)) {
                subchannel = existingSubchannel;
                SubChannels.updateAttributes(existingSubchannel, originalAddressGroup.getAttributes());
            } else {
                subchannel = SubChannels.createSubChannel(this.helper, strippedAddressGroup, originalAddressGroup.getAttributes());
                subchannel.start(state -> this.processSubchannelState(subchannel, state));
                this.subchannels.put(strippedAddressGroup, subchannel);
            }
            subchannel.requestConnection();
        }
        ArrayList<LoadBalancer.Subchannel> removedSubchannels = new ArrayList<LoadBalancer.Subchannel>();
        for (EquivalentAddressGroup addressGroup : removedAddrs) {
            removedSubchannels.add(this.subchannels.remove(addressGroup));
        }
        this.updateBalancingState();
        for (LoadBalancer.Subchannel removedSubchannel : removedSubchannels) {
            this.shutdownSubchannel(removedSubchannel);
        }
    }

    private void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        ConnectivityStateInfo originStateInfo;
        if (this.subchannels.get(AbstractLoadBalancer.stripAttrs(subchannel.getAddresses())) != subchannel) {
            return;
        }
        if (stateInfo.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
            log.info("AbstractLoadBalancer.handleSubchannelState, current state:IDLE, subchannel.requestConnection().");
        }
        if ((originStateInfo = SubChannels.getStateInfo(subchannel)).getState().equals((Object)ConnectivityState.TRANSIENT_FAILURE) && (stateInfo.getState().equals((Object)ConnectivityState.CONNECTING) || stateInfo.getState().equals((Object)ConnectivityState.IDLE))) {
            return;
        }
        SubChannels.setStateInfo(subchannel, stateInfo);
        this.updateBalancingState();
    }

    private Map<EquivalentAddressGroup, EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
        HashMap<EquivalentAddressGroup, EquivalentAddressGroup> addrs = new HashMap<EquivalentAddressGroup, EquivalentAddressGroup>(groupList.size() * 2);
        for (EquivalentAddressGroup group : groupList) {
            addrs.put(AbstractLoadBalancer.stripAttrs(group), group);
        }
        return addrs;
    }

    private static EquivalentAddressGroup stripAttrs(EquivalentAddressGroup eag) {
        return new EquivalentAddressGroup(eag.getAddresses());
    }

    private <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
        HashSet<T> aCopy = new HashSet<T>(a);
        aCopy.removeAll(b);
        return aCopy;
    }

    public void shutdown() {
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            this.shutdownSubchannel(subchannel);
        }
    }

    private void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        SubChannels.setStateInfo(subchannel, ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.SHUTDOWN));
    }

    public void handleNameResolutionError(Status error) {
        this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.currentPicker instanceof AbstractReadyPicker ? this.currentPicker : new EmptyPicker(error));
    }

    private void updateBalancingState() {
        List activeList = this.subchannels.values().stream().filter(r -> SubChannels.getStateInfo(r).getState() == ConnectivityState.READY).collect(Collectors.toList());
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            Status aggStatus = EMPTY_OK;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = SubChannels.getStateInfo(subchannel);
                if (stateInfo.getState() == ConnectivityState.CONNECTING || stateInfo.getState() == ConnectivityState.IDLE) {
                    isConnecting = true;
                }
                if (aggStatus != EMPTY_OK && aggStatus.isOk()) continue;
                aggStatus = stateInfo.getStatus();
            }
            this.updateBalancingState(isConnecting ? ConnectivityState.CONNECTING : ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(aggStatus));
        } else {
            this.updateBalancingState(ConnectivityState.READY, this.newPicker(new ArrayList<LoadBalancer.Subchannel>(this.subchannels.values())));
        }
    }

    private void updateBalancingState(ConnectivityState state, AbstractPicker picker) {
        if (state == this.currentState && picker.isEquivalentTo(this.currentPicker)) {
            return;
        }
        this.helper.updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
        this.currentState = state;
        this.currentPicker = picker;
        log.info("AbstractPicker update, serviceName:{}, all subchannels:{}, state:{}", new Object[]{this.serviceName, picker.getSubchannelsInfo(), state});
    }

    private Collection<LoadBalancer.Subchannel> getSubchannels() {
        return this.subchannels.values();
    }

    protected abstract AbstractReadyPicker newPicker(List<LoadBalancer.Subchannel> var1);
}

