/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DynamicMessage;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.grpc.proto.CompleteObserver;
import org.apache.shenyu.plugin.grpc.proto.CompositeStreamObserver;
import org.apache.shenyu.plugin.grpc.proto.MessageWriter;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcCallRequest;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcResponse;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuGrpcClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShenyuGrpcClient.class);
    private final ManagedChannel channel;

    public ShenyuGrpcClient(ManagedChannel channel) {
        this.channel = channel;
    }

    public CompletableFuture<ShenyuGrpcResponse> call(MetaData metaData, CallOptions callOptions, String requestJsons, MethodDescriptor.MethodType methodType) {
        List jsonRequestList = JsonMessage.buildJsonMessageList((Map)GsonUtils.getInstance().toObjectMap(requestJsons));
        DynamicMessage jsonResponse = JsonMessage.buildJsonMessage();
        MethodDescriptor jsonMarshallerMethodDescriptor = JsonMessage.createJsonMarshallerMethodDescriptor((String)metaData.getServiceName(), (String)metaData.getMethodName(), (MethodDescriptor.MethodType)methodType, (DynamicMessage)((DynamicMessage)jsonRequestList.get(0)), (DynamicMessage)jsonResponse);
        ShenyuGrpcResponse shenyuGrpcResponse = new ShenyuGrpcResponse();
        MessageWriter<DynamicMessage> streamObserver = MessageWriter.newInstance(shenyuGrpcResponse);
        ShenyuGrpcCallRequest callParams = ShenyuGrpcCallRequest.builder().methodDescriptor((MethodDescriptor<DynamicMessage, DynamicMessage>)jsonMarshallerMethodDescriptor).channel((Channel)this.channel).callOptions(callOptions).requests(jsonRequestList).responseObserver(streamObserver).build();
        try {
            this.invoke(callParams).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Caught exception while waiting for rpc :{ " + e.getMessage() + "}");
        }
        return CompletableFuture.completedFuture(shenyuGrpcResponse);
    }

    public ListenableFuture<Void> invoke(ShenyuGrpcCallRequest callParams) {
        MethodDescriptor.MethodType methodType = callParams.getMethodDescriptor().getType();
        List<DynamicMessage> requestList = callParams.getRequests();
        StreamObserver<DynamicMessage> responseObserver = callParams.getResponseObserver();
        CompleteObserver doneObserver = new CompleteObserver();
        CompositeStreamObserver<DynamicMessage> compositeObserver = CompositeStreamObserver.of(responseObserver, doneObserver);
        switch (methodType) {
            case UNARY: {
                ClientCalls.asyncUnaryCall(this.createCall(callParams), (Object)requestList.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case SERVER_STREAMING: {
                ClientCalls.asyncServerStreamingCall(this.createCall(callParams), (Object)requestList.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case CLIENT_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncClientStreamingCall(this.createCall(callParams), compositeObserver);
                requestList.forEach(arg_0 -> ((StreamObserver)requestObserver).onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
            case BIDI_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncBidiStreamingCall(this.createCall(callParams), compositeObserver);
                requestList.forEach(arg_0 -> ((StreamObserver)requestObserver).onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
        }
        log.info("Unknown methodType:{}", (Object)methodType);
        return null;
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    private ClientCall<DynamicMessage, DynamicMessage> createCall(ShenyuGrpcCallRequest callParams) {
        return callParams.getChannel().newCall(callParams.getMethodDescriptor(), callParams.getCallOptions());
    }
}

