/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.security.SecureRandom;
import java.util.List;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class RandomLoadBalancer
extends AbstractLoadBalancer {
    private static final SecureRandom RANDOM = new SecureRandom();

    @Override
    public Upstream doSelect(List<Upstream> upstreamList, String ip) {
        int totalWeight = this.calculateTotalWeight(upstreamList);
        boolean sameWeight = this.isAllUpStreamSameWeight(upstreamList);
        if (totalWeight > 0 && !sameWeight) {
            return this.random(totalWeight, upstreamList);
        }
        return this.random(upstreamList);
    }

    private boolean isAllUpStreamSameWeight(List<Upstream> upstreamList) {
        boolean sameWeight = true;
        int length = upstreamList.size();
        for (int i = 0; i < length; ++i) {
            int weight = this.getWeight(upstreamList.get(i));
            if (i <= 0 || weight == this.getWeight(upstreamList.get(i - 1))) continue;
            sameWeight = false;
            break;
        }
        return sameWeight;
    }

    private int calculateTotalWeight(List<Upstream> upstreamList) {
        int totalWeight = 0;
        for (Upstream divideUpstream : upstreamList) {
            int weight = this.getWeight(divideUpstream);
            totalWeight += weight;
        }
        return totalWeight;
    }

    private Upstream random(int totalWeight, List<Upstream> upstreamList) {
        int offset = RANDOM.nextInt(totalWeight);
        for (Upstream divideUpstream : upstreamList) {
            if ((offset -= this.getWeight(divideUpstream)) >= 0) continue;
            return divideUpstream;
        }
        return upstreamList.get(0);
    }

    private Upstream random(List<Upstream> upstreamList) {
        return upstreamList.get(RANDOM.nextInt(upstreamList.size()));
    }
}

