/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.LoadBalancer;

public abstract class AbstractLoadBalancer
implements LoadBalancer {
    protected abstract Upstream doSelect(List<Upstream> var1, String var2);

    @Override
    public Upstream select(List<Upstream> upstreamList, String ip) {
        if (Objects.isNull(upstreamList) || CollectionUtils.isEmpty(upstreamList)) {
            return null;
        }
        if (upstreamList.size() == 1) {
            return upstreamList.get(0);
        }
        return this.doSelect(upstreamList, ip);
    }

    protected int getWeight(Upstream upstream) {
        if (!upstream.isStatus()) {
            return 0;
        }
        return this.getWeight(upstream.getTimestamp(), upstream.getWarmup(), upstream.getWeight());
    }

    private int getWeight(long timestamp, int warmup, int weight) {
        int uptime;
        if (weight > 0 && timestamp > 0L && (uptime = (int)(System.currentTimeMillis() - timestamp)) > 0 && uptime < warmup) {
            return this.calculateWarmupWeight(uptime, warmup, weight);
        }
        return weight;
    }

    private int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)((float)uptime / ((float)warmup / (float)weight));
        return ww < 1 ? 1 : Math.min(ww, weight);
    }
}

