/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.TCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl.PostgreSQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLBeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLCommitPreparedStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLLockStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLPrepareTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLRollbackPreparedStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLRollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLSetConstraintsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLSetTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.tcl.PostgreSQLStartTransactionStatement;

public final class PostgreSQLTCLStatementSQLVisitor
extends PostgreSQLStatementSQLVisitor
implements TCLSQLVisitor,
SQLStatementVisitor {
    public PostgreSQLTCLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitSetTransaction(PostgreSQLStatementParser.SetTransactionContext ctx) {
        PostgreSQLSetTransactionStatement result = new PostgreSQLSetTransactionStatement();
        if (null != ctx.transactionModeList()) {
            ctx.transactionModeList().transactionModeItem().forEach(each -> {
                result.setAccessMode(this.getTransactionAccessType((PostgreSQLStatementParser.TransactionModeItemContext)((Object)each)));
                result.setIsolationLevel(this.getTransactionIsolationLevel((PostgreSQLStatementParser.TransactionModeItemContext)((Object)each)));
            });
        }
        return result;
    }

    private TransactionAccessType getTransactionAccessType(PostgreSQLStatementParser.TransactionModeItemContext modeItemContext) {
        if (null != modeItemContext.ONLY()) {
            return TransactionAccessType.READ_ONLY;
        }
        if (null != modeItemContext.WRITE()) {
            return TransactionAccessType.READ_WRITE;
        }
        return null;
    }

    private TransactionIsolationLevel getTransactionIsolationLevel(PostgreSQLStatementParser.TransactionModeItemContext modeItemContext) {
        if (null == modeItemContext.isoLevel()) {
            return null;
        }
        if (null != modeItemContext.isoLevel().UNCOMMITTED()) {
            return TransactionIsolationLevel.READ_UNCOMMITTED;
        }
        if (null != modeItemContext.isoLevel().COMMITTED()) {
            return TransactionIsolationLevel.READ_COMMITTED;
        }
        if (null != modeItemContext.isoLevel().REPEATABLE()) {
            return TransactionIsolationLevel.REPEATABLE_READ;
        }
        if (null != modeItemContext.isoLevel().SERIALIZABLE()) {
            return TransactionIsolationLevel.SERIALIZABLE;
        }
        return null;
    }

    @Override
    public ASTNode visitBeginTransaction(PostgreSQLStatementParser.BeginTransactionContext ctx) {
        return new PostgreSQLBeginTransactionStatement();
    }

    @Override
    public ASTNode visitCommit(PostgreSQLStatementParser.CommitContext ctx) {
        return new PostgreSQLCommitStatement();
    }

    @Override
    public ASTNode visitRollback(PostgreSQLStatementParser.RollbackContext ctx) {
        return new PostgreSQLRollbackStatement();
    }

    @Override
    public ASTNode visitAbort(PostgreSQLStatementParser.AbortContext ctx) {
        return new PostgreSQLRollbackStatement();
    }

    @Override
    public ASTNode visitSavepoint(PostgreSQLStatementParser.SavepointContext ctx) {
        String savepointName = ctx.colId().getText();
        PostgreSQLSavepointStatement result = new PostgreSQLSavepointStatement();
        result.setSavepointName(savepointName);
        return result;
    }

    @Override
    public ASTNode visitRollbackToSavepoint(PostgreSQLStatementParser.RollbackToSavepointContext ctx) {
        PostgreSQLRollbackStatement result = new PostgreSQLRollbackStatement();
        result.setSavepointName(ctx.colId().getText());
        return result;
    }

    @Override
    public ASTNode visitReleaseSavepoint(PostgreSQLStatementParser.ReleaseSavepointContext ctx) {
        String savepointName = ctx.colId().getText();
        PostgreSQLReleaseSavepointStatement result = new PostgreSQLReleaseSavepointStatement();
        result.setSavepointName(savepointName);
        return result;
    }

    @Override
    public ASTNode visitStartTransaction(PostgreSQLStatementParser.StartTransactionContext ctx) {
        return new PostgreSQLStartTransactionStatement();
    }

    @Override
    public ASTNode visitEnd(PostgreSQLStatementParser.EndContext ctx) {
        return new PostgreSQLCommitStatement();
    }

    @Override
    public ASTNode visitSetConstraints(PostgreSQLStatementParser.SetConstraintsContext ctx) {
        return new PostgreSQLSetConstraintsStatement();
    }

    @Override
    public ASTNode visitCommitPrepared(PostgreSQLStatementParser.CommitPreparedContext ctx) {
        return new PostgreSQLCommitPreparedStatement();
    }

    @Override
    public ASTNode visitRollbackPrepared(PostgreSQLStatementParser.RollbackPreparedContext ctx) {
        return new PostgreSQLRollbackPreparedStatement();
    }

    @Override
    public ASTNode visitLock(PostgreSQLStatementParser.LockContext ctx) {
        PostgreSQLLockStatement result = new PostgreSQLLockStatement();
        if (null != ctx.relationExprList()) {
            result.getTables().addAll(this.getLockTables(ctx.relationExprList().relationExpr()));
        }
        return result;
    }

    private Collection<SimpleTableSegment> getLockTables(List<PostgreSQLStatementParser.RelationExprContext> relationExprContexts) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (PostgreSQLStatementParser.RelationExprContext each : relationExprContexts) {
            SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)each.qualifiedName());
            result.add(tableSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitPrepareTransaction(PostgreSQLStatementParser.PrepareTransactionContext ctx) {
        return new PostgreSQLPrepareTransactionStatement();
    }

    @Generated
    public PostgreSQLTCLStatementSQLVisitor() {
    }
}

