/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.database.parser;

import lombok.Generated;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.ParseContext;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.core.database.parser.DatabaseTypedSQLParserFacadeRegistry;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.DatabaseTypedSQLParserFacade;

public final class SQLParserExecutor {
    private final String databaseType;
    private final boolean sqlCommentParseEnabled;

    public ParseContext parse(String sql) {
        ParseASTNode result = this.twoPhaseParse(sql);
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", sql);
        }
        return new ParseContext(result.getRootNode(), result.getHiddenTokens());
    }

    private ParseASTNode twoPhaseParse(String sql) {
        DatabaseTypedSQLParserFacade sqlParserFacade = DatabaseTypedSQLParserFacadeRegistry.getFacade(this.databaseType);
        SQLParser sqlParser = SQLParserFactory.newInstance(sql, sqlParserFacade.getLexerClass(), sqlParserFacade.getParserClass(), this.sqlCommentParseEnabled);
        try {
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            try {
                return (ParseASTNode)sqlParser.parse();
            }
            catch (ParseCancellationException e) {
                throw new SQLParsingException("You have an error in your SQL syntax");
            }
        }
    }

    @Generated
    public SQLParserExecutor(String databaseType, boolean sqlCommentParseEnabled) {
        this.databaseType = databaseType;
        this.sqlCommentParseEnabled = sqlCommentParseEnabled;
    }
}

