/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.parser.yaml.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.nodepath.GlobalNodePath;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.NewYamlGlobalRuleConfigurationSwapper;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.parser.rule.builder.DefaultSQLParserRuleConfigurationBuilder;
import org.apache.shardingsphere.parser.yaml.config.YamlSQLParserRuleConfiguration;
import org.apache.shardingsphere.parser.yaml.swapper.YamlSQLParserCacheOptionConfigurationSwapper;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class NewYamlSQLParserRuleConfigurationSwapper
implements NewYamlGlobalRuleConfigurationSwapper<SQLParserRuleConfiguration> {
    private final YamlSQLParserCacheOptionConfigurationSwapper cacheOptionSwapper = new YamlSQLParserCacheOptionConfigurationSwapper();

    public Collection<YamlDataNode> swapToDataNodes(SQLParserRuleConfiguration data) {
        return Collections.singletonList(new YamlDataNode(this.getRuleTagName().toLowerCase(), YamlEngine.marshal((Object)this.swapToYamlConfiguration(data))));
    }

    private YamlSQLParserRuleConfiguration swapToYamlConfiguration(SQLParserRuleConfiguration data) {
        YamlSQLParserRuleConfiguration result = new YamlSQLParserRuleConfiguration();
        result.setSqlCommentParseEnabled(data.isSqlCommentParseEnabled());
        result.setParseTreeCache(this.cacheOptionSwapper.swapToYamlConfiguration(data.getParseTreeCache()));
        result.setSqlStatementCache(this.cacheOptionSwapper.swapToYamlConfiguration(data.getSqlStatementCache()));
        return result;
    }

    public Optional<SQLParserRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        for (YamlDataNode each : dataNodes) {
            Optional version = GlobalNodePath.getVersion((String)this.getRuleTagName().toLowerCase(), (String)each.getKey());
            if (!version.isPresent()) continue;
            return Optional.of(this.swapToObject((YamlSQLParserRuleConfiguration)YamlEngine.unmarshal((String)each.getValue(), YamlSQLParserRuleConfiguration.class)));
        }
        return Optional.empty();
    }

    private SQLParserRuleConfiguration swapToObject(YamlSQLParserRuleConfiguration yamlConfig) {
        CacheOption parseTreeCacheOption = null == yamlConfig.getParseTreeCache() ? DefaultSQLParserRuleConfigurationBuilder.PARSE_TREE_CACHE_OPTION : this.cacheOptionSwapper.swapToObject(yamlConfig.getParseTreeCache());
        CacheOption sqlStatementCacheOption = null == yamlConfig.getSqlStatementCache() ? DefaultSQLParserRuleConfigurationBuilder.SQL_STATEMENT_CACHE_OPTION : this.cacheOptionSwapper.swapToObject(yamlConfig.getSqlStatementCache());
        return new SQLParserRuleConfiguration(yamlConfig.isSqlCommentParseEnabled(), parseTreeCacheOption, sqlStatementCacheOption);
    }

    public Class<SQLParserRuleConfiguration> getTypeClass() {
        return SQLParserRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SQL_PARSER";
    }

    public int getOrder() {
        return 700;
    }
}

