/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.parser.rule;

import lombok.Generated;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.parser.SimpleSQLParserEngine;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class SQLParserRule
implements GlobalRule {
    private final SQLParserRuleConfiguration configuration;
    private final boolean sqlCommentParseEnabled;
    private final CacheOption sqlStatementCache;
    private final CacheOption parseTreeCache;
    private final String engineType;

    public SQLParserRule(SQLParserRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.sqlCommentParseEnabled = ruleConfig.isSqlCommentParseEnabled();
        this.sqlStatementCache = ruleConfig.getSqlStatementCache();
        this.parseTreeCache = ruleConfig.getParseTreeCache();
        this.engineType = "Standard";
    }

    public SQLParserEngine getSQLParserEngine(String databaseType) {
        return "Standard".equals(this.engineType) ? new ShardingSphereSQLParserEngine(databaseType, this.sqlStatementCache, this.parseTreeCache, this.sqlCommentParseEnabled) : new SimpleSQLParserEngine();
    }

    public String getType() {
        return SQLParserRule.class.getSimpleName();
    }

    @Generated
    public SQLParserRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public boolean isSqlCommentParseEnabled() {
        return this.sqlCommentParseEnabled;
    }

    @Generated
    public CacheOption getSqlStatementCache() {
        return this.sqlStatementCache;
    }

    @Generated
    public CacheOption getParseTreeCache() {
        return this.parseTreeCache;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }
}

