/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.spring.namespace.parser.rule;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.spring.namespace.factorybean.KeyGenerateAlgorithmFactoryBean;
import org.apache.shardingsphere.sharding.spring.namespace.factorybean.ShardingAlgorithmFactoryBean;
import org.apache.shardingsphere.spring.namespace.registry.ShardingSphereAlgorithmBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ShardingRuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AlgorithmProvidedShardingRuleConfiguration.class);
        factory.addPropertyValue("tables", this.parseTableRulesConfiguration(element));
        factory.addPropertyValue("autoTables", this.parseAutoTableRulesConfiguration(element));
        factory.addPropertyValue("bindingTableGroups", this.parseBindingTablesConfiguration(element));
        factory.addPropertyValue("broadcastTables", this.parseBroadcastTables(element));
        this.setDefaultDatabaseShardingStrategyRef(element, factory);
        this.setDefaultTableShardingStrategyRef(element, factory);
        this.setDefaultKeyGenerateStrategyRef(element, factory);
        factory.addPropertyValue("shardingAlgorithms", (Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, ShardingAlgorithmFactoryBean.class));
        factory.addPropertyValue("keyGenerators", (Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, KeyGenerateAlgorithmFactoryBean.class));
        return factory.getBeanDefinition();
    }

    private List<BeanDefinition> parseTableRulesConfiguration(Element element) {
        Element tableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"table-rules");
        if (null == tableRulesElement) {
            return Collections.emptyList();
        }
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)tableRulesElement, (String)"table-rule");
        ManagedList result = new ManagedList(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.add(this.parseTableRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseTableRuleConfiguration(Element tableElement) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingTableRuleConfiguration.class);
        factory.addConstructorArgValue((Object)tableElement.getAttribute("logic-table"));
        this.parseActualDataNodes(tableElement, factory);
        this.parseDatabaseShardingStrategyConfiguration(tableElement, factory);
        this.parseTableShardingStrategyConfiguration(tableElement, factory);
        this.parseKeyGenerateStrategyConfiguration(tableElement, factory);
        return factory.getBeanDefinition();
    }

    private void parseActualDataNodes(Element tableElement, BeanDefinitionBuilder factory) {
        String actualDataNodes = tableElement.getAttribute("actual-data-nodes");
        if (!Strings.isNullOrEmpty((String)actualDataNodes)) {
            factory.addConstructorArgValue((Object)actualDataNodes);
        }
    }

    private void parseDatabaseShardingStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String databaseStrategy = tableElement.getAttribute("database-strategy-ref");
        if (!Strings.isNullOrEmpty((String)databaseStrategy)) {
            factory.addPropertyReference("databaseShardingStrategy", databaseStrategy);
        }
    }

    private void parseTableShardingStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String tableStrategy = tableElement.getAttribute("table-strategy-ref");
        if (!Strings.isNullOrEmpty((String)tableStrategy)) {
            factory.addPropertyReference("tableShardingStrategy", tableStrategy);
        }
    }

    private List<BeanDefinition> parseAutoTableRulesConfiguration(Element element) {
        Element tableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"auto-table-rules");
        if (null == tableRulesElement) {
            return Collections.emptyList();
        }
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)tableRulesElement, (String)"auto-table-rule");
        ManagedList result = new ManagedList(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.add(this.parseAutoTableRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseAutoTableRuleConfiguration(Element tableElement) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingAutoTableRuleConfiguration.class);
        factory.addConstructorArgValue((Object)tableElement.getAttribute("logic-table"));
        this.parseActualDataSources(tableElement, factory);
        this.parseShardingStrategyConfiguration(tableElement, factory);
        this.parseKeyGenerateStrategyConfiguration(tableElement, factory);
        return factory.getBeanDefinition();
    }

    private void parseActualDataSources(Element tableElement, BeanDefinitionBuilder factory) {
        String actualDataNodes = tableElement.getAttribute("actual-data-sources");
        if (!Strings.isNullOrEmpty((String)actualDataNodes)) {
            factory.addConstructorArgValue((Object)actualDataNodes);
        }
    }

    private void parseShardingStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String databaseStrategy = tableElement.getAttribute("sharding-strategy-ref");
        if (!Strings.isNullOrEmpty((String)databaseStrategy)) {
            factory.addPropertyReference("shardingStrategy", databaseStrategy);
        }
    }

    private void parseKeyGenerateStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String keyGenerator = tableElement.getAttribute("key-generate-strategy-ref");
        if (!Strings.isNullOrEmpty((String)keyGenerator)) {
            factory.addPropertyReference("keyGenerateStrategy", keyGenerator);
        }
    }

    private List<String> parseBindingTablesConfiguration(Element element) {
        Element bindingTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"binding-table-rules");
        if (null == bindingTableRulesElement) {
            return Collections.emptyList();
        }
        List bindingTableRuleElements = DomUtils.getChildElementsByTagName((Element)bindingTableRulesElement, (String)"binding-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : bindingTableRuleElements) {
            result.add(each.getAttribute("logic-tables"));
        }
        return result;
    }

    private List<String> parseBroadcastTables(Element element) {
        Element broadcastTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"broadcast-table-rules");
        if (null == broadcastTableRulesElement) {
            return Collections.emptyList();
        }
        List broadcastTableRuleElements = DomUtils.getChildElementsByTagName((Element)broadcastTableRulesElement, (String)"broadcast-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : broadcastTableRuleElements) {
            result.add(each.getAttribute("table"));
        }
        return result;
    }

    private void setDefaultDatabaseShardingStrategyRef(Element element, BeanDefinitionBuilder factory) {
        Optional<String> strategyRef = this.parseStrategyRef(element, "default-database-strategy-ref");
        strategyRef.ifPresent(optional -> factory.addPropertyReference("defaultDatabaseShardingStrategy", optional));
    }

    private void setDefaultTableShardingStrategyRef(Element element, BeanDefinitionBuilder factory) {
        Optional<String> strategyRef = this.parseStrategyRef(element, "default-table-strategy-ref");
        strategyRef.ifPresent(optional -> factory.addPropertyReference("defaultTableShardingStrategy", optional));
    }

    private void setDefaultKeyGenerateStrategyRef(Element element, BeanDefinitionBuilder factory) {
        Optional<String> strategyRef = this.parseStrategyRef(element, "default-key-generate-strategy-ref");
        strategyRef.ifPresent(optional -> factory.addPropertyReference("defaultKeyGenerateStrategy", optional));
    }

    private Optional<String> parseStrategyRef(Element element, String tagName) {
        String result = element.getAttribute(tagName);
        return Strings.isNullOrEmpty((String)result) ? Optional.empty() : Optional.of(result);
    }
}

