/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.scaling.mysql.component;

import com.google.common.collect.ImmutableMap;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.ScalingSQLBuilder;
import org.apache.shardingsphere.scaling.core.config.ImporterConfiguration;
import org.apache.shardingsphere.scaling.core.executor.importer.AbstractImporter;
import org.apache.shardingsphere.scaling.core.util.JDBCUtil;

import java.util.Map;
import java.util.Set;

/**
 * MySQL importer.
 */
public final class MySQLImporter extends AbstractImporter {
    
    public MySQLImporter(final ImporterConfiguration importerConfig, final DataSourceManager dataSourceManager) {
        super(importerConfig, dataSourceManager);
        JDBCUtil.appendJDBCParameter(importerConfig.getDataSourceConfig(), ImmutableMap.<String, String>builder().put("rewriteBatchedStatements", "true").build());
    }
    
    @Override
    protected ScalingSQLBuilder createSQLBuilder(final Map<String, Set<String>> shardingColumnsMap) {
        return new MySQLScalingSQLBuilder(shardingColumnsMap);
    }
}
