/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.reactive.mysql.command.query.text.fieldlist;

import com.google.common.base.Preconditions;
import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.fieldlist.MySQLComFieldListPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.reactive.command.executor.ReactiveCommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ReactiveMySQLComFieldListPacketExecutor
implements ReactiveCommandExecutor {
    private static final String SQL = "SHOW COLUMNS FROM %s FROM %s";
    private final MySQLComFieldListPacket packet;
    private final String schemaName;
    private final VertxDatabaseCommunicationEngine databaseCommunicationEngine;
    private final int characterSet;
    private int currentSequenceId;

    public ReactiveMySQLComFieldListPacketExecutor(MySQLComFieldListPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.schemaName = connectionSession.getDefaultSchemaName();
        String sql = String.format(SQL, packet.getTable(), this.schemaName);
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional sqlParserRule = metaDataContexts.getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(this.schemaName).getResource().getDatabaseType()), ((SQLParserRule)sqlParserRule.get()).toParserConfiguration());
        SQLStatement sqlStatement = sqlStatementParserEngine.parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaDataMap(), (SQLStatement)sqlStatement, (String)this.schemaName);
        this.databaseCommunicationEngine = (VertxDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newTextProtocolInstance(sqlStatementContext, sql, connectionSession.getBackendConnection());
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Future<Collection<DatabasePacket<?>>> executeFuture() {
        return this.databaseCommunicationEngine.execute().compose(unused -> {
            try {
                return Future.succeededFuture(this.createColumnDefinition41Packets());
            }
            catch (SQLException ex) {
                return Future.failedFuture((Throwable)ex);
            }
        });
    }

    private Collection<DatabasePacket<?>> createColumnDefinition41Packets() throws SQLException {
        LinkedList result = new LinkedList();
        while (this.databaseCommunicationEngine.next()) {
            String columnName = ((QueryResponseCell)this.databaseCommunicationEngine.getQueryResponseRow().getCells().iterator().next()).getData().toString();
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, this.schemaName, this.packet.getTable(), this.packet.getTable(), columnName, columnName, 100, MySQLBinaryColumnType.MYSQL_TYPE_VARCHAR, 0, true));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
        return result;
    }
}

