/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.reactive.mysql.command.query.binary.execute;

import com.google.common.base.Preconditions;
import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.binary.BinaryRow;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLBinaryResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.proxy.frontend.reactive.command.executor.ReactiveCommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;

public final class ReactiveMySQLComStmtExecuteExecutor
implements ReactiveCommandExecutor {
    private final VertxDatabaseCommunicationEngine databaseCommunicationEngine;
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final int characterSet;
    private volatile ResponseType responseType;
    private int currentSequenceId;

    public ReactiveMySQLComStmtExecuteExecutor(MySQLComStmtExecutePacket packet, ConnectionSession connectionSession) throws SQLException {
        String schemaName = connectionSession.getSchemaName();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional sqlParserRule = metaDataContexts.getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(schemaName).getResource().getDatabaseType()), ((SQLParserRule)sqlParserRule.get()).toParserConfiguration());
        SQLStatement sqlStatement = sqlStatementParserEngine.parse(packet.getSql(), true);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaDataMap(), (List)packet.getParameters(), (SQLStatement)sqlStatement, (String)connectionSession.getDefaultSchemaName());
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().ifPresent(SQLStatementSchemaHolder::set);
        }
        SQLCheckEngine.check((SQLStatement)sqlStatement, Collections.emptyList(), ReactiveMySQLComStmtExecuteExecutor.getRules(schemaName), (String)schemaName, (Map)metaDataContexts.getMetaDataMap(), (Grantee)connectionSession.getGrantee());
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
        if (sqlStatement instanceof TCLStatement) {
            this.databaseCommunicationEngine = null;
            this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeRegistry.getActualDatabaseType((String)"MySQL"), (String)packet.getSql(), () -> Optional.of(sqlStatement), (ConnectionSession)connectionSession);
            return;
        }
        this.textProtocolBackendHandler = null;
        this.databaseCommunicationEngine = (VertxDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(sqlStatementContext, packet.getSql(), packet.getParameters(), connectionSession.getBackendConnection());
    }

    private static Collection<ShardingSphereRule> getRules(String schemaName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    public Future<Collection<DatabasePacket<?>>> executeFuture() {
        return (null != this.databaseCommunicationEngine ? this.databaseCommunicationEngine.execute() : this.textProtocolBackendHandler.executeFuture()).compose(responseHeader -> {
            Collection<DatabasePacket<?>> headerPackets = responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader) : this.processUpdate((UpdateResponseHeader)responseHeader);
            LinkedList result = new LinkedList(headerPackets);
            if (ResponseType.UPDATE == this.responseType) {
                return Future.succeededFuture(result);
            }
            try {
                while (this.next()) {
                    result.add((DatabasePacket<?>)this.getQueryRowPacket());
                }
                result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
                return Future.succeededFuture(result);
            }
            catch (SQLException ex) {
                return Future.failedFuture((Throwable)ex);
            }
        });
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        Collection result = ResponsePacketBuilder.buildQueryResponsePackets((QueryResponseHeader)queryResponseHeader, (int)this.characterSet);
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets((UpdateResponseHeader)updateResponseHeader);
    }

    private boolean next() throws SQLException {
        return null != this.databaseCommunicationEngine && this.databaseCommunicationEngine.next();
    }

    private MySQLPacket getQueryRowPacket() throws SQLException {
        QueryResponseRow queryResponseRow = this.databaseCommunicationEngine.getQueryResponseRow();
        return new MySQLBinaryResultSetRowPacket(++this.currentSequenceId, this.createBinaryRow(queryResponseRow));
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        ArrayList<BinaryCell> result = new ArrayList<BinaryCell>(queryResponseRow.getCells().size());
        for (QueryResponseCell each : queryResponseRow.getCells()) {
            result.add(new BinaryCell((BinaryColumnType)MySQLBinaryColumnType.valueOfJDBCType((int)((BinaryQueryResponseCell)each).getJdbcType()), each.getData()));
        }
        return new BinaryRow(result);
    }

    public Future<Void> closeFuture() {
        try {
            if (null != this.textProtocolBackendHandler) {
                this.textProtocolBackendHandler.close();
            }
            return Future.succeededFuture();
        }
        catch (SQLException ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

