/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.reactive.mysql.command.query.text.query;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.proxy.frontend.reactive.command.executor.ReactiveCommandExecutor;

public final class ReactiveMySQLComQueryPacketExecutor
implements ReactiveCommandExecutor {
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final int characterSet;
    private ResponseType responseType;
    private int currentSequenceId;

    public ReactiveMySQLComQueryPacketExecutor(MySQLComQueryPacket packet, ConnectionSession connectionSession) throws SQLException {
        this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeRegistry.getActualDatabaseType((String)"MySQL"), (String)packet.getSql(), Optional::empty, (ConnectionSession)connectionSession);
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Future<Collection<DatabasePacket<?>>> executeFuture() {
        return this.textProtocolBackendHandler.executeFuture().compose(responseHeader -> {
            LinkedList result = new LinkedList(responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader) : this.processUpdate((UpdateResponseHeader)responseHeader));
            try {
                if (ResponseType.QUERY == this.responseType) {
                    while (this.textProtocolBackendHandler.next()) {
                        result.add((DatabasePacket<?>)new MySQLTextResultSetRowPacket(++this.currentSequenceId, this.textProtocolBackendHandler.getRowData()));
                    }
                    result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
                }
                return Future.succeededFuture(result);
            }
            catch (SQLException ex) {
                return Future.failedFuture((Throwable)ex);
            }
        });
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        Collection result = ResponsePacketBuilder.buildQueryResponsePackets((QueryResponseHeader)queryResponseHeader, (int)this.characterSet);
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets((UpdateResponseHeader)updateResponseHeader);
    }

    public Future<Void> closeFuture() {
        try {
            this.textProtocolBackendHandler.close();
            return Future.succeededFuture();
        }
        catch (SQLException ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }
}

