/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLParseCompletePacket;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;

public final class PostgreSQLComParseExecutor
implements CommandExecutor {
    private final PostgreSQLComParsePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket<?>> execute() {
        SQLStatement sqlStatement = this.parseSql(this.packet.getSql(), this.connectionSession.getSchemaName());
        List<PostgreSQLColumnType> paddedColumnTypes = this.paddingColumnTypes(sqlStatement.getParameterCount(), this.packet.readParameterTypes());
        PostgreSQLPreparedStatementRegistry.getInstance().register(this.connectionSession.getConnectionId(), this.packet.getStatementId(), this.packet.getSql(), sqlStatement, paddedColumnTypes);
        return Collections.singletonList(PostgreSQLParseCompletePacket.getInstance());
    }

    private SQLStatement parseSql(String sql, String schemaName) {
        if (sql.isEmpty()) {
            return new EmptyStatement();
        }
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(schemaName).getResource().getDatabaseType()), (SQLParserRule)metaDataContexts.getGlobalRuleMetaData().findSingleRule(SQLParserRule.class).orElse(null));
        return sqlStatementParserEngine.parse(sql, true);
    }

    private List<PostgreSQLColumnType> paddingColumnTypes(int parameterCount, List<PostgreSQLColumnType> specifiedColumnTypes) {
        if (parameterCount == specifiedColumnTypes.size()) {
            return specifiedColumnTypes;
        }
        ArrayList<PostgreSQLColumnType> result = new ArrayList<PostgreSQLColumnType>(parameterCount);
        result.addAll(specifiedColumnTypes);
        for (int i = 0; i < parameterCount; ++i) {
            result.add(PostgreSQLColumnType.POSTGRESQL_TYPE_UNSPECIFIED);
        }
        return result;
    }

    @Generated
    public PostgreSQLComParseExecutor(PostgreSQLComParsePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

