/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.describe;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class PostgreSQLComDescribeExecutor
implements CommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final PostgreSQLComDescribePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        switch (this.packet.getType()) {
            case 'S': {
                return this.describePreparedStatement();
            }
            case 'P': {
                return Collections.singletonList(this.connectionContext.getPortal(this.packet.getName()).describe());
            }
        }
        throw new UnsupportedOperationException("Unsupported describe type: " + this.packet.getType());
    }

    private List<DatabasePacket<?>> describePreparedStatement() throws SQLException {
        ArrayList result = new ArrayList(2);
        PostgreSQLPreparedStatement preparedStatement = PostgreSQLPreparedStatementRegistry.getInstance().get(this.connectionSession.getConnectionId(), this.packet.getName());
        result.add((DatabasePacket<?>)preparedStatement.describeParameters());
        Optional rowDescription = preparedStatement.describeRows();
        if (rowDescription.isPresent()) {
            result.add((DatabasePacket<?>)rowDescription.get());
        } else {
            this.tryDescribePreparedStatement(preparedStatement);
            preparedStatement.describeRows().ifPresent(result::add);
        }
        return result;
    }

    private void tryDescribePreparedStatement(PostgreSQLPreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement.getSqlStatement() instanceof InsertStatement) {
            this.describeInsertStatementByShardingSphereMetaData(preparedStatement);
            return;
        }
        this.tryDescribePreparedStatementByJDBC(preparedStatement);
    }

    private void describeInsertStatementByShardingSphereMetaData(PostgreSQLPreparedStatement preparedStatement) {
        InsertStatement insertStatement;
        if (!preparedStatement.describeRows().isPresent()) {
            preparedStatement.setRowDescription((PostgreSQLPacket)PostgreSQLNoDataPacket.getInstance());
        }
        if (0 == (insertStatement = (InsertStatement)preparedStatement.getSqlStatement()).getParameterCount()) {
            return;
        }
        Set<Integer> unspecifiedTypeParameterIndexes = this.getUnspecifiedTypeParameterIndexes(preparedStatement);
        if (unspecifiedTypeParameterIndexes.isEmpty()) {
            return;
        }
        String schemaName = this.connectionSession.getSchemaName();
        String logicTableName = insertStatement.getTable().getTableName().getIdentifier().getValue();
        TableMetaData tableMetaData = ProxyContext.getInstance().getMetaData(schemaName).getSchema().get(logicTableName);
        Map columnMetaData = tableMetaData.getColumns();
        List<Object> columnNames = insertStatement.getColumns().isEmpty() ? new ArrayList(tableMetaData.getColumns().keySet()) : insertStatement.getColumns().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
        Iterator iterator = insertStatement.getValues().iterator();
        int parameterMarkerIndex = 0;
        while (iterator.hasNext()) {
            InsertValuesSegment each2 = (InsertValuesSegment)iterator.next();
            ListIterator listIterator = each2.getValues().listIterator();
            int columnIndex = listIterator.nextIndex();
            while (listIterator.hasNext()) {
                ExpressionSegment value = (ExpressionSegment)listIterator.next();
                if (value instanceof ParameterMarkerExpressionSegment) {
                    if (!unspecifiedTypeParameterIndexes.contains(parameterMarkerIndex)) {
                        ++parameterMarkerIndex;
                    } else {
                        String columnName = (String)columnNames.get(columnIndex);
                        PostgreSQLColumnType parameterType = PostgreSQLColumnType.valueOfJDBCType((int)((ColumnMetaData)columnMetaData.get(columnName)).getDataType());
                        preparedStatement.getParameterTypes().set(parameterMarkerIndex++, parameterType);
                    }
                }
                columnIndex = listIterator.nextIndex();
            }
        }
    }

    private Set<Integer> getUnspecifiedTypeParameterIndexes(PostgreSQLPreparedStatement preparedStatement) {
        HashSet<Integer> unspecifiedTypeParameterIndexes = new HashSet<Integer>();
        ListIterator parameterTypesListIterator = preparedStatement.getParameterTypes().listIterator();
        int index = parameterTypesListIterator.nextIndex();
        while (parameterTypesListIterator.hasNext()) {
            if (PostgreSQLColumnType.POSTGRESQL_TYPE_UNSPECIFIED == parameterTypesListIterator.next()) {
                unspecifiedTypeParameterIndexes.add(index);
            }
            index = parameterTypesListIterator.nextIndex();
        }
        return unspecifiedTypeParameterIndexes;
    }

    private void tryDescribePreparedStatementByJDBC(PostgreSQLPreparedStatement preparedStatement) throws SQLException {
        if (!(this.connectionSession.getBackendConnection() instanceof JDBCBackendConnection)) {
            return;
        }
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String schemaName = this.connectionSession.getSchemaName();
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaDataMap(), Collections.emptyList(), (SQLStatement)preparedStatement.getSqlStatement(), (String)schemaName);
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, preparedStatement.getSql(), Collections.emptyList());
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getMetaData(schemaName);
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(logicSQL, metaData, metaDataContexts.getProps());
        ExecutionUnit executionUnitSample = (ExecutionUnit)executionContext.getExecutionUnits().iterator().next();
        JDBCBackendConnection backendConnection = (JDBCBackendConnection)this.connectionSession.getBackendConnection();
        Connection connection = (Connection)backendConnection.getConnections(executionUnitSample.getDataSourceName(), 1, ConnectionMode.CONNECTION_STRICTLY).iterator().next();
        try (PreparedStatement ps = connection.prepareStatement(executionUnitSample.getSqlUnit().getSql());){
            this.populateParameterTypes(preparedStatement, ps);
            this.populateColumnTypes(preparedStatement, ps);
        }
    }

    private void populateParameterTypes(PostgreSQLPreparedStatement preparedStatement, PreparedStatement ps) throws SQLException {
        if (0 == preparedStatement.getSqlStatement().getParameterCount() || preparedStatement.getParameterTypes().stream().noneMatch(each -> PostgreSQLColumnType.POSTGRESQL_TYPE_UNSPECIFIED == each)) {
            return;
        }
        ParameterMetaData parameterMetaData = ps.getParameterMetaData();
        for (int i = 0; i < preparedStatement.getSqlStatement().getParameterCount(); ++i) {
            if (PostgreSQLColumnType.POSTGRESQL_TYPE_UNSPECIFIED != preparedStatement.getParameterTypes().get(i)) continue;
            preparedStatement.getParameterTypes().set(i, PostgreSQLColumnType.valueOfJDBCType((int)parameterMetaData.getParameterType(i + 1)));
        }
    }

    private void populateColumnTypes(PostgreSQLPreparedStatement preparedStatement, PreparedStatement ps) throws SQLException {
        if (preparedStatement.describeRows().isPresent()) {
            return;
        }
        ResultSetMetaData resultSetMetaData = ps.getMetaData();
        if (null == resultSetMetaData) {
            preparedStatement.setRowDescription((PostgreSQLPacket)PostgreSQLNoDataPacket.getInstance());
            return;
        }
        ArrayList<PostgreSQLColumnDescription> columnDescriptions = new ArrayList<PostgreSQLColumnDescription>(resultSetMetaData.getColumnCount());
        for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
            String columnName = resultSetMetaData.getColumnName(columnIndex);
            int columnType = resultSetMetaData.getColumnType(columnIndex);
            int columnLength = resultSetMetaData.getColumnDisplaySize(columnIndex);
            String columnTypeName = resultSetMetaData.getColumnTypeName(columnIndex);
            columnDescriptions.add(new PostgreSQLColumnDescription(columnName, columnIndex, columnType, columnLength, columnTypeName));
        }
        preparedStatement.setRowDescription((PostgreSQLPacket)new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions));
    }

    @Generated
    public PostgreSQLComDescribeExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComDescribePacket packet, ConnectionSession connectionSession) {
        this.connectionContext = connectionContext;
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

