/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.close;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.close.PostgreSQLCloseCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;

public final class PostgreSQLComCloseExecutor
implements CommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final PostgreSQLComClosePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        switch (this.packet.getType()) {
            case PREPARED_STATEMENT: {
                PostgreSQLPreparedStatementRegistry.getInstance().unregister(this.connectionSession.getConnectionId(), this.packet.getName());
                break;
            }
            case PORTAL: {
                this.closePortal();
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.packet.getType().name());
            }
        }
        return Collections.singletonList(new PostgreSQLCloseCompletePacket());
    }

    private void closePortal() throws SQLException {
        this.connectionContext.closePortal(this.packet.getName());
    }

    @Generated
    public PostgreSQLComCloseExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComClosePacket packet, ConnectionSession connectionSession) {
        this.connectionContext = connectionContext;
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

