/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.bind;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLBindCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.JDBCPortal;

public final class PostgreSQLComBindExecutor
implements CommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final PostgreSQLComBindPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        PostgreSQLPreparedStatement preparedStatement = PostgreSQLPreparedStatementRegistry.getInstance().get(this.connectionSession.getConnectionId(), this.packet.getStatementId());
        JDBCBackendConnection backendConnection = (JDBCBackendConnection)this.connectionSession.getBackendConnection();
        JDBCPortal portal = new JDBCPortal(this.packet.getPortal(), preparedStatement, this.packet.readParameters(preparedStatement.getParameterTypes()), this.packet.readResultFormats(), backendConnection);
        this.connectionContext.addPortal(portal);
        portal.bind();
        return Collections.singletonList(PostgreSQLBindCompletePacket.getInstance());
    }

    @Generated
    public PostgreSQLComBindExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComBindPacket packet, ConnectionSession connectionSession) {
        this.connectionContext = connectionContext;
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

