/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLTypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorDriverManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class PostgreSQLBatchedInsertsExecutor {
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final JDBCExecutor jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), false);
    private final ConnectionSession connectionSession;
    private final MetaDataContexts metaDataContexts;
    private final PostgreSQLPreparedStatement preparedStatement;
    private final Map<ExecutionUnit, List<List<Object>>> executionUnitParameters;
    private ExecutionContext anyExecutionContext;
    private ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext;

    public PostgreSQLBatchedInsertsExecutor(ConnectionSession connectionSession, PostgreSQLPreparedStatement preparedStatement, List<List<Object>> parameterSets) {
        this.connectionSession = connectionSession;
        this.metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        this.preparedStatement = preparedStatement;
        this.executionUnitParameters = new HashMap<ExecutionUnit, List<List<Object>>>();
        for (List<Object> eachGroupParameter : parameterSets) {
            ExecutionContext executionContext = this.createExecutionContext(this.createLogicSQL(eachGroupParameter));
            if (null == this.anyExecutionContext) {
                this.anyExecutionContext = executionContext;
            }
            for (ExecutionUnit each : executionContext.getExecutionUnits()) {
                this.executionUnitParameters.computeIfAbsent(each, unused -> new LinkedList()).add(each.getSqlUnit().getParameters());
            }
        }
    }

    private LogicSQL createLogicSQL(List<Object> parameters) {
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaDataMap(), parameters, (SQLStatement)this.preparedStatement.getSqlStatement(), (String)this.connectionSession.getSchemaName());
        return new LogicSQL(sqlStatementContext, this.preparedStatement.getSql(), parameters);
    }

    private ExecutionContext createExecutionContext(LogicSQL logicSQL) {
        SQLCheckEngine.check((SQLStatement)logicSQL.getSqlStatementContext().getSqlStatement(), (List)logicSQL.getParameters(), (Collection)this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getRuleMetaData().getRules(), (String)this.connectionSession.getSchemaName(), (Map)this.metaDataContexts.getMetaDataMap(), null);
        return this.kernelProcessor.generateExecutionContext(logicSQL, this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()), this.metaDataContexts.getProps());
    }

    public int executeBatch() throws SQLException {
        this.addBatchedParametersToPreparedStatements();
        return this.executeBatchedPreparedStatements();
    }

    private void addBatchedParametersToPreparedStatements() throws SQLException {
        Collection rules = this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getRuleMetaData().getRules();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", ((Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), (ExecutorDriverManager)((JDBCBackendConnection)this.connectionSession.getBackendConnection()), (StorageResourceOption)new StatementOption(false), rules);
        this.executionGroupContext = prepareEngine.prepare(this.anyExecutionContext.getRouteContext(), this.executionUnitParameters.keySet());
        for (ExecutionGroup eachGroup : this.executionGroupContext.getInputGroups()) {
            for (JDBCExecutionUnit each : eachGroup.getInputs()) {
                this.prepareJDBCExecutionUnit(each);
            }
        }
    }

    private void prepareJDBCExecutionUnit(JDBCExecutionUnit jdbcExecutionUnit) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)jdbcExecutionUnit.getStorageResource();
        for (List eachGroupParameter : this.executionUnitParameters.getOrDefault(jdbcExecutionUnit.getExecutionUnit(), Collections.emptyList())) {
            ListIterator parametersIterator = eachGroupParameter.listIterator();
            while (parametersIterator.hasNext()) {
                int parameterIndex = parametersIterator.nextIndex() + 1;
                Object value = parametersIterator.next();
                if (value instanceof PostgreSQLTypeUnspecifiedSQLParameter) {
                    value = value.toString();
                }
                preparedStatement.setObject(parameterIndex, value);
            }
            preparedStatement.addBatch();
        }
    }

    private int executeBatchedPreparedStatements() throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        DatabaseType databaseType = this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getResource().getDatabaseType();
        BatchedInsertsJDBCExecutorCallback callback = new BatchedInsertsJDBCExecutorCallback(databaseType, this.preparedStatement.getSqlStatement(), isExceptionThrown);
        List executeResults = this.jdbcExecutor.execute(this.executionGroupContext, (JDBCExecutorCallback)callback);
        int result = 0;
        Iterator iterator = executeResults.iterator();
        while (iterator.hasNext()) {
            int[] eachResult;
            for (int each : eachResult = (int[])iterator.next()) {
                result += each;
            }
        }
        return result;
    }

    private static class BatchedInsertsJDBCExecutorCallback
    extends JDBCExecutorCallback<int[]> {
        BatchedInsertsJDBCExecutorCallback(DatabaseType databaseType, SQLStatement sqlStatement, boolean isExceptionThrown) {
            super(databaseType, sqlStatement, isExceptionThrown);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
            try {
                int[] nArray = statement.executeBatch();
                return nArray;
            }
            finally {
                statement.close();
            }
        }

        protected Optional<int[]> getSaneResult(SQLStatement sqlStatement) {
            return Optional.empty();
        }
    }
}

