/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLEmptyQueryResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLPortalSuspendedPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.Portal;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;

public final class JDBCPortal
implements Portal<Void> {
    private final String name;
    private final SQLStatement sqlStatement;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final JDBCDatabaseCommunicationEngine databaseCommunicationEngine;
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final JDBCBackendConnection backendConnection;
    private ResponseHeader responseHeader;

    public JDBCPortal(String name, PostgreSQLPreparedStatement preparedStatement, List<Object> parameters, List<PostgreSQLValueFormat> resultFormats, JDBCBackendConnection backendConnection) throws SQLException {
        this.name = name;
        this.sqlStatement = preparedStatement.getSqlStatement();
        this.resultFormats = resultFormats;
        this.backendConnection = backendConnection;
        if (this.sqlStatement instanceof TCLStatement || this.sqlStatement instanceof EmptyStatement || this.sqlStatement instanceof DistSQLStatement) {
            this.databaseCommunicationEngine = null;
            this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeRegistry.getActualDatabaseType((String)"PostgreSQL"), (String)preparedStatement.getSql(), () -> Optional.of(this.sqlStatement), (ConnectionSession)backendConnection.getConnectionSession());
            return;
        }
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap(), parameters, (SQLStatement)this.sqlStatement, (String)backendConnection.getConnectionSession().getDefaultSchemaName());
        this.databaseCommunicationEngine = (JDBCDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(sqlStatementContext, preparedStatement.getSql(), parameters, (BackendConnection)backendConnection);
        this.textProtocolBackendHandler = null;
    }

    @Override
    public Void bind() {
        this.responseHeader = null != this.databaseCommunicationEngine ? this.databaseCommunicationEngine.execute() : this.textProtocolBackendHandler.execute();
        return null;
    }

    @Override
    public PostgreSQLPacket describe() {
        if (this.responseHeader instanceof QueryResponseHeader) {
            return this.createRowDescriptionPacket((QueryResponseHeader)this.responseHeader);
        }
        if (this.responseHeader instanceof UpdateResponseHeader) {
            return PostgreSQLNoDataPacket.getInstance();
        }
        throw new IllegalStateException("Cannot describe portal [" + this.name + "] before bind");
    }

    private PostgreSQLRowDescriptionPacket createRowDescriptionPacket(QueryResponseHeader queryResponseHeader) {
        Collection<PostgreSQLColumnDescription> columnDescriptions = this.createColumnDescriptions(queryResponseHeader);
        return new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions);
    }

    private Collection<PostgreSQLColumnDescription> createColumnDescriptions(QueryResponseHeader queryResponseHeader) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponseHeader.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnLabel(), ++columnIndex, each.getColumnType(), each.getColumnLength(), each.getColumnTypeName()));
        }
        return result;
    }

    @Override
    public List<PostgreSQLPacket> execute(int maxRows) {
        int fetchSize = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        LinkedList<PostgreSQLPacket> result = new LinkedList<PostgreSQLPacket>();
        for (int i = 0; i < fetchSize && this.hasNext(); ++i) {
            result.add(this.nextPacket());
        }
        result.add((PostgreSQLPacket)this.createExecutionCompletedPacket(maxRows > 0 && maxRows == result.size(), result.size()));
        return result;
    }

    private boolean hasNext() throws SQLException {
        return null != this.databaseCommunicationEngine && this.databaseCommunicationEngine.next() || null != this.textProtocolBackendHandler && this.textProtocolBackendHandler.next();
    }

    private PostgreSQLPacket nextPacket() throws SQLException {
        return null != this.databaseCommunicationEngine ? new PostgreSQLDataRowPacket(this.getData(this.databaseCommunicationEngine.getQueryResponseRow())) : new PostgreSQLDataRowPacket(this.textProtocolBackendHandler.getRowData());
    }

    private List<Object> getData(QueryResponseRow queryResponseRow) {
        Collection cells = queryResponseRow.getCells();
        ArrayList<Object> result = new ArrayList<Object>(cells.size());
        ArrayList columns = new ArrayList(cells);
        for (int i = 0; i < columns.size(); ++i) {
            PostgreSQLValueFormat format = this.determineValueFormat(i);
            result.add(PostgreSQLValueFormat.BINARY == format ? this.createBinaryCell((QueryResponseCell)columns.get(i)) : ((QueryResponseCell)columns.get(i)).getData());
        }
        return result;
    }

    private PostgreSQLValueFormat determineValueFormat(int columnIndex) {
        return this.resultFormats.isEmpty() ? PostgreSQLValueFormat.TEXT : this.resultFormats.get(columnIndex % this.resultFormats.size());
    }

    private BinaryCell createBinaryCell(QueryResponseCell cell) {
        return new BinaryCell((BinaryColumnType)PostgreSQLColumnType.valueOfJDBCType((int)((BinaryQueryResponseCell)cell).getJdbcType()), cell.getData());
    }

    private PostgreSQLIdentifierPacket createExecutionCompletedPacket(boolean isSuspended, int fetchedRows) {
        if (isSuspended) {
            this.suspendPortal();
            return new PostgreSQLPortalSuspendedPacket();
        }
        if (this.getSqlStatement() instanceof EmptyStatement) {
            return new PostgreSQLEmptyQueryResponsePacket();
        }
        String sqlCommand = PostgreSQLCommand.valueOf(this.getSqlStatement().getClass()).map(PostgreSQLCommand::getTag).orElse("");
        return new PostgreSQLCommandCompletePacket(sqlCommand, Math.max((long)fetchedRows, this.getUpdateCount()));
    }

    private void suspendPortal() {
        this.backendConnection.markResourceInUse(this.databaseCommunicationEngine);
    }

    private long getUpdateCount() {
        return this.responseHeader instanceof UpdateResponseHeader ? ((UpdateResponseHeader)this.responseHeader).getUpdateCount() : 0L;
    }

    @Override
    public void close() {
        if (null != this.databaseCommunicationEngine) {
            this.backendConnection.unmarkResourceInUse(this.databaseCommunicationEngine);
        }
        if (null != this.textProtocolBackendHandler) {
            this.textProtocolBackendHandler.close();
        }
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }
}

