/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.Portal;

public final class PostgreSQLConnectionContext {
    private final Map<String, Portal<?>> portals = new LinkedHashMap();

    public void addPortal(Portal<?> portal) {
        boolean isNamedPortal;
        boolean bl = isNamedPortal = !portal.getName().isEmpty();
        if (isNamedPortal && this.portals.containsKey(portal.getName())) {
            throw new IllegalStateException("Named portal [" + portal.getName() + "] must be explicitly closed");
        }
        Portal<?> previousPortal = this.portals.put(portal.getName(), portal);
        if (null != previousPortal) {
            previousPortal.close();
        }
    }

    public <T extends Portal<?>> T getPortal(String portal) {
        return (T)this.portals.get(portal);
    }

    public void closePortal(String portal) {
        Portal<?> result = this.portals.remove(portal);
        if (null != result) {
            result.close();
        }
    }

    public void closeAllPortals() {
        for (Portal<?> each : this.portals.values()) {
            each.close();
        }
        this.portals.clear();
    }
}

