/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketTypeLoader;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContextRegistry;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.simple.PostgreSQLComQueryExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.err.PostgreSQLErrPacketFactory;

public final class PostgreSQLCommandExecuteEngine
implements CommandExecuteEngine {
    public PostgreSQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return PostgreSQLCommandPacketTypeLoader.getCommandPacketType((PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload));
    }

    public PostgreSQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, ConnectionSession connectionSession) {
        return PostgreSQLCommandPacketFactory.newInstance((PostgreSQLCommandPacketType)((PostgreSQLCommandPacketType)type), (PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload));
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, ConnectionSession connectionSession) throws SQLException {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(connectionSession.getConnectionId());
        return PostgreSQLCommandExecutorFactory.newInstance((PostgreSQLCommandPacketType)type, (PostgreSQLCommandPacket)packet, connectionSession, connectionContext);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause) {
        return PostgreSQLErrPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket<?>> getOtherPacket(ConnectionSession connectionSession) {
        return Optional.of(connectionSession.getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.TRANSACTION_FAILED : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
    }

    public boolean writeQueryData(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY == queryCommandExecutor.getResponseType() && !context.channel().isActive()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), 0L));
            return true;
        }
        if (queryCommandExecutor instanceof PostgreSQLComQueryExecutor) {
            return this.processSimpleQuery(context, (JDBCBackendConnection)backendConnection, (PostgreSQLComQueryExecutor)queryCommandExecutor);
        }
        this.writeDataPackets(context, (JDBCBackendConnection)backendConnection, queryCommandExecutor);
        return false;
    }

    private boolean processSimpleQuery(ChannelHandlerContext context, JDBCBackendConnection backendConnection, PostgreSQLComQueryExecutor queryExecutor) throws SQLException {
        if (ResponseType.UPDATE == queryExecutor.getResponseType()) {
            context.write((Object)(backendConnection.getConnectionSession().getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.IN_TRANSACTION : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION));
            return true;
        }
        long dataRows = this.writeDataPackets(context, backendConnection, queryExecutor);
        if (ResponseType.QUERY == queryExecutor.getResponseType()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), dataRows));
        }
        context.write((Object)(backendConnection.getConnectionSession().getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.IN_TRANSACTION : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION));
        return true;
    }

    private long writeDataPackets(ChannelHandlerContext context, JDBCBackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor) throws SQLException {
        long dataRows = 0L;
        int flushCount = 0;
        int proxyFrontendFlushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandExecutor.next()) {
            ++flushCount;
            while (!context.channel().isWritable() && context.channel().isActive()) {
                context.flush();
                backendConnection.getResourceLock().doAwait();
            }
            DatabasePacket resultValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)resultValue);
            if (proxyFrontendFlushThreshold == flushCount) {
                context.flush();
                flushCount = 0;
            }
            if (!(resultValue instanceof PostgreSQLDataRowPacket)) continue;
            ++dataRows;
        }
        return dataRows;
    }
}

