/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.authentication;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLErrorCode;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLServerInfo;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLAuthenticationMD5PasswordPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLAuthenticationOKPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLComStartupPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLPasswordMessagePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLRandomGenerator;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLSSLNegativePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResult;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResultBuilder;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLAuthenticationHandler;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLLoginResult;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.InvalidAuthorizationSpecificationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLAuthenticationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLProtocolViolationException;

public final class PostgreSQLAuthenticationEngine
implements AuthenticationEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private boolean startupMessageReceived;
    private String clientEncoding;
    private byte[] md5Salt;
    private AuthenticationResult currentAuthResult;

    public int handshake(ChannelHandlerContext context) {
        int result = ConnectionIdGenerator.getInstance().nextId();
        PostgreSQLPreparedStatementRegistry.getInstance().register(result);
        return result;
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        if (8 == payload.getByteBuf().markReaderIndex().readInt() && 80877103 == payload.getByteBuf().readInt()) {
            context.writeAndFlush((Object)new PostgreSQLSSLNegativePacket());
            return AuthenticationResultBuilder.continued();
        }
        payload.getByteBuf().resetReaderIndex();
        return this.startupMessageReceived ? this.processPasswordMessage(context, (PostgreSQLPacketPayload)payload) : this.processStartupMessage(context, (PostgreSQLPacketPayload)payload);
    }

    private AuthenticationResult processStartupMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload) {
        this.startupMessageReceived = true;
        PostgreSQLComStartupPacket comStartupPacket = new PostgreSQLComStartupPacket(payload);
        this.clientEncoding = comStartupPacket.getClientEncoding();
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)Charset.forName(this.clientEncoding));
        String user = comStartupPacket.getUser();
        if (Strings.isNullOrEmpty((String)user)) {
            throw new InvalidAuthorizationSpecificationException("no PostgreSQL user name specified in startup packet");
        }
        this.md5Salt = PostgreSQLRandomGenerator.getInstance().generateRandomBytes(4);
        context.writeAndFlush((Object)new PostgreSQLAuthenticationMD5PasswordPacket(this.md5Salt));
        this.currentAuthResult = AuthenticationResultBuilder.continued((String)user, (String)"", (String)comStartupPacket.getDatabase());
        return this.currentAuthResult;
    }

    private AuthenticationResult processPasswordMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload) {
        char messageType = (char)payload.readInt1();
        if (PostgreSQLMessagePacketType.PASSWORD_MESSAGE.getValue() != messageType) {
            throw new PostgreSQLProtocolViolationException("password", Character.toString(messageType));
        }
        PostgreSQLPasswordMessagePacket passwordMessagePacket = new PostgreSQLPasswordMessagePacket(payload);
        PostgreSQLLoginResult loginResult = PostgreSQLAuthenticationHandler.loginWithMd5Password(this.currentAuthResult.getUsername(), this.currentAuthResult.getDatabase(), this.md5Salt, passwordMessagePacket);
        if (PostgreSQLErrorCode.SUCCESSFUL_COMPLETION != loginResult.getErrorCode()) {
            throw new PostgreSQLAuthenticationException(loginResult.getErrorCode(), loginResult.getErrorMessage());
        }
        context.write((Object)new PostgreSQLAuthenticationOKPacket());
        context.write((Object)new PostgreSQLParameterStatusPacket("server_version", PostgreSQLServerInfo.getServerVersion()));
        context.write((Object)new PostgreSQLParameterStatusPacket("client_encoding", this.clientEncoding));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_encoding", "UTF8"));
        context.write((Object)new PostgreSQLParameterStatusPacket("integer_datetimes", "on"));
        context.writeAndFlush((Object)PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)"", (String)this.currentAuthResult.getDatabase());
    }
}

