/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.codec.PostgreSQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLServerInfo;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLPreparedStatementRegistry;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.context.FrontendContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContextRegistry;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class PostgreSQLFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final FrontendContext frontendContext = new FrontendContext(true, true);
    private final AuthenticationEngine authenticationEngine = new PostgreSQLAuthenticationEngine();
    private final CommandExecuteEngine commandExecuteEngine = new PostgreSQLCommandExecuteEngine();
    private final DatabasePacketCodecEngine<PostgreSQLPacket> codecEngine = new PostgreSQLPacketCodecEngine();

    public void setDatabaseVersion(String databaseVersion) {
        PostgreSQLServerInfo.setServerVersion((String)databaseVersion);
    }

    public void release(ConnectionSession connectionSession) {
        PostgreSQLPreparedStatementRegistry.getInstance().unregister(connectionSession.getConnectionId());
        PostgreSQLConnectionContextRegistry.getInstance().remove(connectionSession.getConnectionId());
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    @Generated
    public FrontendContext getFrontendContext() {
        return this.frontendContext;
    }

    @Generated
    public AuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public CommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public DatabasePacketCodecEngine<PostgreSQLPacket> getCodecEngine() {
        return this.codecEngine;
    }
}

