/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.err;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.generic.OpenGaussErrorResponsePacket;
import org.apache.shardingsphere.dialect.exception.SQLDialectException;
import org.apache.shardingsphere.dialect.mapper.SQLDialectExceptionMapperFactory;
import org.apache.shardingsphere.dialect.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.infra.util.exception.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.InvalidAuthorizationSpecificationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLAuthenticationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLProtocolViolationException;

public final class OpenGaussErrorPacketFactory {
    private static final Class<?> PSQL_EXCEPTION_CLASS;
    private static final Method GET_SERVER_ERROR_MESSAGE_METHOD;
    private static final Class<?> SERVER_ERROR_MESSAGE_CLASS;
    private static final Field MESSAGE_PARTS_FIELD;

    public static OpenGaussErrorResponsePacket newInstance(Exception cause) {
        if (OpenGaussErrorPacketFactory.existsServerErrorMessage(cause)) {
            return OpenGaussErrorPacketFactory.createErrorResponsePacket(OpenGaussErrorPacketFactory.getServerErrorMessageMap(cause));
        }
        if (cause instanceof SQLException) {
            return OpenGaussErrorPacketFactory.createErrorResponsePacket((SQLException)cause);
        }
        if (cause instanceof SQLDialectException) {
            return OpenGaussErrorPacketFactory.createErrorResponsePacket(SQLDialectExceptionMapperFactory.getInstance((String)"PostgreSQL").convert((SQLDialectException)cause));
        }
        if (cause instanceof ShardingSphereSQLException) {
            return OpenGaussErrorPacketFactory.createErrorResponsePacket(((ShardingSphereSQLException)cause).toSQLException());
        }
        if (cause instanceof InvalidAuthorizationSpecificationException) {
            return new OpenGaussErrorResponsePacket("FATAL", PostgreSQLVendorError.INVALID_AUTHORIZATION_SPECIFICATION.getSqlState().getValue(), cause.getMessage());
        }
        if (cause instanceof PostgreSQLProtocolViolationException) {
            return new OpenGaussErrorResponsePacket("FATAL", PostgreSQLVendorError.PROTOCOL_VIOLATION.getSqlState().getValue(), String.format("expected %s response, got message type %s", ((PostgreSQLProtocolViolationException)cause).getExpectedMessageType(), ((PostgreSQLProtocolViolationException)cause).getActualMessageType()));
        }
        if (cause instanceof PostgreSQLAuthenticationException) {
            return new OpenGaussErrorResponsePacket("FATAL", ((PostgreSQLAuthenticationException)cause).getVendorError().getSqlState().getValue(), cause.getMessage());
        }
        return OpenGaussErrorPacketFactory.createErrorResponsePacketForUnknownException(cause);
    }

    private static boolean existsServerErrorMessage(Exception cause) {
        return PSQL_EXCEPTION_CLASS.isInstance(cause) && null != GET_SERVER_ERROR_MESSAGE_METHOD.invoke((Object)cause, new Object[0]);
    }

    private static Map<Character, String> getServerErrorMessageMap(Exception cause) {
        return (Map)MESSAGE_PARTS_FIELD.get(GET_SERVER_ERROR_MESSAGE_METHOD.invoke((Object)cause, new Object[0]));
    }

    private static OpenGaussErrorResponsePacket createErrorResponsePacket(SQLException cause) {
        String sqlState = Strings.isNullOrEmpty((String)cause.getSQLState()) ? PostgreSQLVendorError.SYSTEM_ERROR.getSqlState().getValue() : cause.getSQLState();
        String message = Strings.isNullOrEmpty((String)cause.getMessage()) ? cause.toString() : cause.getMessage();
        return new OpenGaussErrorResponsePacket("ERROR", sqlState, message);
    }

    private static OpenGaussErrorResponsePacket createErrorResponsePacket(Map<Character, String> serverErrorMessageMap) {
        return new OpenGaussErrorResponsePacket(serverErrorMessageMap);
    }

    private static OpenGaussErrorResponsePacket createErrorResponsePacketForUnknownException(Exception cause) {
        String message = Strings.isNullOrEmpty((String)cause.getLocalizedMessage()) ? cause.toString() : cause.getLocalizedMessage();
        return new OpenGaussErrorResponsePacket("ERROR", PostgreSQLVendorError.SYSTEM_ERROR.getSqlState().getValue(), message);
    }

    @Generated
    private OpenGaussErrorPacketFactory() {
    }

    static {
        try {
            PSQL_EXCEPTION_CLASS = Class.forName("org.opengauss.util.PSQLException");
            GET_SERVER_ERROR_MESSAGE_METHOD = PSQL_EXCEPTION_CLASS.getMethod("getServerErrorMessage", new Class[0]);
            SERVER_ERROR_MESSAGE_CLASS = Class.forName("org.opengauss.util.ServerErrorMessage");
            MESSAGE_PARTS_FIELD = SERVER_ERROR_MESSAGE_CLASS.getDeclaredField("m_mesgParts");
            MESSAGE_PARTS_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

