/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.authentication;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussAuthenticationSCRAMSha256Packet;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLServerInfo;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLAuthenticationOKPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLComStartupPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLPasswordMessagePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLSSLNegativePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.dialect.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLCharacterSets;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResult;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResultBuilder;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.opengauss.authentication.OpenGaussAuthenticationHandler;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLLoginResult;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.InvalidAuthorizationSpecificationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLAuthenticationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLProtocolViolationException;

public final class OpenGaussAuthenticationEngine
implements AuthenticationEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private boolean startupMessageReceived;
    private String clientEncoding;
    private final String saltHexString = this.generateRandomHexString(64);
    private final String nonceHexString = this.generateRandomHexString(8);
    private final int serverIteration;
    private AuthenticationResult currentAuthResult;

    public OpenGaussAuthenticationEngine() {
        this.serverIteration = 10000;
    }

    private String generateRandomHexString(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < result.capacity(); ++i) {
            result.append(Integer.toString(random.nextInt(16), 16));
        }
        return result.toString();
    }

    public int handshake(ChannelHandlerContext context) {
        return ConnectionIdGenerator.getInstance().nextId();
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        if (8 == payload.getByteBuf().markReaderIndex().readInt() && 80877103 == payload.getByteBuf().readInt()) {
            context.writeAndFlush((Object)new PostgreSQLSSLNegativePacket());
            return AuthenticationResultBuilder.continued();
        }
        payload.getByteBuf().resetReaderIndex();
        return this.startupMessageReceived ? this.processPasswordMessage(context, (PostgreSQLPacketPayload)payload) : this.processStartupMessage(context, (PostgreSQLPacketPayload)payload);
    }

    private AuthenticationResult processStartupMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload) {
        this.startupMessageReceived = true;
        PostgreSQLComStartupPacket comStartupPacket = new PostgreSQLComStartupPacket(payload);
        this.clientEncoding = comStartupPacket.getClientEncoding();
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)PostgreSQLCharacterSets.findCharacterSet((String)this.clientEncoding));
        String user = comStartupPacket.getUser();
        if (Strings.isNullOrEmpty((String)user)) {
            throw new InvalidAuthorizationSpecificationException("no PostgreSQL user name specified in startup packet");
        }
        context.writeAndFlush((Object)new OpenGaussAuthenticationSCRAMSha256Packet(this.saltHexString.getBytes(), this.nonceHexString.getBytes(), this.serverIteration));
        this.currentAuthResult = AuthenticationResultBuilder.continued((String)user, (String)"", (String)comStartupPacket.getDatabase());
        return this.currentAuthResult;
    }

    private AuthenticationResult processPasswordMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload) {
        char messageType = (char)payload.readInt1();
        if (PostgreSQLMessagePacketType.PASSWORD_MESSAGE.getValue() != messageType) {
            throw new PostgreSQLProtocolViolationException("password", Character.toString(messageType));
        }
        PostgreSQLPasswordMessagePacket passwordMessagePacket = new PostgreSQLPasswordMessagePacket(payload);
        PostgreSQLLoginResult loginResult = OpenGaussAuthenticationHandler.loginWithSCRAMSha256Password(this.currentAuthResult.getUsername(), this.currentAuthResult.getDatabase(), this.saltHexString, this.nonceHexString, this.serverIteration, passwordMessagePacket);
        if (PostgreSQLVendorError.SUCCESSFUL_COMPLETION != loginResult.getVendorError()) {
            throw new PostgreSQLAuthenticationException(loginResult.getVendorError(), loginResult.getErrorMessage());
        }
        context.write((Object)new PostgreSQLAuthenticationOKPacket());
        context.write((Object)new PostgreSQLParameterStatusPacket("server_version", PostgreSQLServerInfo.getServerVersion()));
        context.write((Object)new PostgreSQLParameterStatusPacket("client_encoding", this.clientEncoding));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_encoding", "UTF8"));
        context.write((Object)new PostgreSQLParameterStatusPacket("integer_datetimes", "on"));
        context.writeAndFlush((Object)PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)"", (String)this.currentAuthResult.getDatabase());
    }
}

