/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.err;

import com.google.common.base.Strings;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobNotFoundException;
import org.apache.shardingsphere.db.protocol.error.CommonErrorCode;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.CircuitBreakException;
import org.apache.shardingsphere.proxy.backend.exception.DBCreateExistsException;
import org.apache.shardingsphere.proxy.backend.exception.DBDropNotExistsException;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseLockedException;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.ResourceNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.exception.TableLockWaitTimeoutException;
import org.apache.shardingsphere.proxy.backend.exception.TableLockedException;
import org.apache.shardingsphere.proxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.CommonDistSQLErrorCode;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.CommonDistSQLException;
import org.apache.shardingsphere.proxy.frontend.exception.FrontendTooManyConnectionsException;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedCommandException;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.exception.UnknownCharacterSetException;
import org.apache.shardingsphere.sharding.route.engine.exception.NoSuchTableException;
import org.apache.shardingsphere.sharding.route.engine.exception.TableExistsException;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class MySQLErrPacketFactory {
    public static MySQLErrPacket newInstance(Exception cause) {
        if (cause instanceof SQLException) {
            SQLException sqlException = (SQLException)cause;
            return null == sqlException.getSQLState() ? new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_INTERNAL_ERROR, new Object[]{MySQLErrPacketFactory.getErrorMessage(sqlException)}) : new MySQLErrPacket(1, sqlException.getErrorCode(), sqlException.getSQLState(), sqlException.getMessage());
        }
        if (cause instanceof CommonDistSQLException) {
            CommonDistSQLException commonDistSQLException = (CommonDistSQLException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonDistSQLErrorCode.valueOf((CommonDistSQLException)commonDistSQLException), new Object[]{commonDistSQLException.getVariable()});
        }
        if (cause instanceof TableModifyInTransactionException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE, new Object[]{((TableModifyInTransactionException)cause).getTableName()});
        }
        if (cause instanceof UnknownDatabaseException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_BAD_DB_ERROR, new Object[]{((UnknownDatabaseException)cause).getDatabaseName()});
        }
        if (cause instanceof DatabaseNotExistedException) {
            return null != ((DatabaseNotExistedException)cause).getDatabaseName() ? new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_BAD_DB_ERROR, new Object[]{((DatabaseNotExistedException)cause).getDatabaseName()}) : new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NO_DB_ERROR, new Object[0]);
        }
        if (cause instanceof NoDatabaseSelectedException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NO_DB_ERROR, new Object[0]);
        }
        if (cause instanceof DBCreateExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_DB_CREATE_EXISTS_ERROR, new Object[]{((DBCreateExistsException)cause).getDatabaseName()});
        }
        if (cause instanceof DBDropNotExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_DB_DROP_NOT_EXISTS_ERROR, new Object[]{((DBDropNotExistsException)cause).getDatabaseName()});
        }
        if (cause instanceof TableExistsException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_TABLE_EXISTS_ERROR, new Object[]{((TableExistsException)cause).getTableName()});
        }
        if (cause instanceof NoSuchTableException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NO_SUCH_TABLE, new Object[]{((NoSuchTableException)cause).getTableName()});
        }
        if (cause instanceof CircuitBreakException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.CIRCUIT_BREAK_MODE, new Object[0]);
        }
        if (cause instanceof UnsupportedCommandException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.UNSUPPORTED_COMMAND, new Object[]{((UnsupportedCommandException)cause).getCommandType()});
        }
        if (cause instanceof UnsupportedPreparedStatementException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_UNSUPPORTED_PS, new Object[0]);
        }
        if (cause instanceof ShardingSphereConfigurationException || cause instanceof SQLParsingException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_NOT_SUPPORTED_YET, new Object[]{cause.getMessage()});
        }
        if (cause instanceof RuleNotExistedException || cause instanceof ResourceNotExistedException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_SP_DOES_NOT_EXIST, new Object[0]);
        }
        if (cause instanceof DatabaseLockedException) {
            DatabaseLockedException exception = (DatabaseLockedException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.DATABASE_WRITE_LOCKED, new Object[]{exception.getDatabaseName()});
        }
        if (cause instanceof TableLockWaitTimeoutException) {
            TableLockWaitTimeoutException exception = (TableLockWaitTimeoutException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.TABLE_LOCK_WAIT_TIMEOUT, new Object[]{exception.getTableName(), exception.getSchemaName(), exception.getTimeoutMilliseconds()});
        }
        if (cause instanceof TableLockedException) {
            TableLockedException exception = (TableLockedException)cause;
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.TABLE_LOCKED, new Object[]{exception.getTableName(), exception.getSchemaName()});
        }
        if (cause instanceof PipelineJobNotFoundException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.SCALING_JOB_NOT_EXIST, new Object[]{((PipelineJobNotFoundException)cause).getJobId()});
        }
        if (cause instanceof FrontendTooManyConnectionsException) {
            return new MySQLErrPacket(0, (SQLErrorCode)MySQLServerErrorCode.ER_CON_COUNT_ERROR, new Object[]{MySQLServerErrorCode.ER_CON_COUNT_ERROR.getErrorMessage()});
        }
        if (cause instanceof UnknownCharacterSetException) {
            return new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_UNKNOWN_CHARACTER_SET, new Object[]{cause.getMessage()});
        }
        if (cause instanceof RuntimeException) {
            return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.RUNTIME_EXCEPTION, new Object[]{cause.getMessage()});
        }
        return new MySQLErrPacket(1, (SQLErrorCode)CommonErrorCode.UNKNOWN_EXCEPTION, new Object[]{cause.getMessage()});
    }

    private static String getErrorMessage(SQLException cause) {
        if (null != cause.getNextException() && Strings.isNullOrEmpty((String)cause.getMessage())) {
            return cause.getNextException().getMessage();
        }
        return cause.getMessage();
    }

    @Generated
    private MySQLErrPacketFactory() {
    }
}

