/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.ClientEncodingResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query.MySQLMultiStatementsHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class MySQLComQueryPacketExecutor
implements QueryCommandExecutor {
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final int characterSet;
    private volatile ResponseType responseType;
    private int currentSequenceId;

    public MySQLComQueryPacketExecutor(MySQLComQueryPacket packet, ConnectionSession connectionSession) throws SQLException {
        DatabaseType databaseType = DatabaseTypeFactory.getInstance((String)"MySQL");
        SQLStatement sqlStatement = this.parseSql(packet.getSql(), databaseType);
        this.textProtocolBackendHandler = this.areMultiStatements(connectionSession, sqlStatement, packet.getSql()) ? new MySQLMultiStatementsHandler(connectionSession, sqlStatement, packet.getSql()) : TextProtocolBackendHandlerFactory.newInstance((DatabaseType)databaseType, (String)packet.getSql(), () -> Optional.of(sqlStatement), (ConnectionSession)connectionSession);
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    private SQLStatement parseSql(String sql, DatabaseType databaseType) {
        if (sql.isEmpty()) {
            return new EmptyStatement();
        }
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional sqlParserRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        return ((SQLParserRule)sqlParserRule.get()).getSQLParserEngine(databaseType.getType()).parse(sql, false);
    }

    private boolean areMultiStatements(ConnectionSession connectionSession, SQLStatement sqlStatement, String sql) {
        return connectionSession.getAttributeMap().hasAttr(MySQLConstants.MYSQL_OPTION_MULTI_STATEMENTS) && 0 == (Integer)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_OPTION_MULTI_STATEMENTS).get() && (sqlStatement instanceof UpdateStatement || sqlStatement instanceof DeleteStatement) && sql.contains(";");
    }

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        ResponseHeader responseHeader = this.textProtocolBackendHandler.execute();
        if (responseHeader instanceof QueryResponseHeader) {
            return this.processQuery((QueryResponseHeader)responseHeader);
        }
        this.responseType = ResponseType.UPDATE;
        return responseHeader instanceof UpdateResponseHeader ? this.processUpdate((UpdateResponseHeader)responseHeader) : this.processClientEncoding((ClientEncodingResponseHeader)responseHeader);
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        Collection<DatabasePacket<?>> result = ResponsePacketBuilder.buildQueryResponsePackets(queryResponseHeader, this.characterSet);
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        return ResponsePacketBuilder.buildUpdateResponsePackets(updateResponseHeader);
    }

    private Collection<DatabasePacket<?>> processClientEncoding(ClientEncodingResponseHeader clientEncodingResponseHeader) {
        Optional currentCharsetValue = clientEncodingResponseHeader.getCurrentCharsetValue();
        if (currentCharsetValue.isPresent()) {
            return Collections.singletonList(new MySQLOKPacket(1, 0L, 0L));
        }
        return Collections.singletonList(new MySQLErrPacket(1, (SQLErrorCode)MySQLServerErrorCode.ER_UNKNOWN_CHARACTER_SET, new Object[]{clientEncodingResponseHeader.getInputValue()}));
    }

    public boolean next() throws SQLException {
        return this.textProtocolBackendHandler.next();
    }

    public MySQLPacket getQueryRowPacket() throws SQLException {
        return new MySQLTextResultSetRowPacket(++this.currentSequenceId, this.textProtocolBackendHandler.getRowData());
    }

    public void close() throws SQLException {
        this.textProtocolBackendHandler.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

