/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnFieldDetailFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLFieldCountPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;

public final class ResponsePacketBuilder {
    public static Collection<DatabasePacket<?>> buildQueryResponsePackets(QueryResponseHeader queryResponseHeader, int characterSet) {
        LinkedList result = new LinkedList();
        int sequenceId = 0;
        List queryHeaders = queryResponseHeader.getQueryHeaders();
        result.add((DatabasePacket<?>)new MySQLFieldCountPacket(++sequenceId, queryHeaders.size()));
        for (QueryHeader each : queryHeaders) {
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++sequenceId, characterSet, ResponsePacketBuilder.getColumnFieldDetailFlag(each), each.getSchema(), each.getTable(), each.getTable(), each.getColumnLabel(), each.getColumnName(), each.getColumnLength(), MySQLBinaryColumnType.valueOfJDBCType((int)each.getColumnType()), each.getDecimals(), false));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++sequenceId));
        return result;
    }

    private static int getColumnFieldDetailFlag(QueryHeader header) {
        int result = 0;
        if (header.isPrimaryKey()) {
            result += MySQLColumnFieldDetailFlag.PRIMARY_KEY.getValue();
        }
        if (header.isNotNull()) {
            result += MySQLColumnFieldDetailFlag.NOT_NULL.getValue();
        }
        if (!header.isSigned()) {
            result += MySQLColumnFieldDetailFlag.UNSIGNED.getValue();
        }
        if (header.isAutoIncrement()) {
            result += MySQLColumnFieldDetailFlag.AUTO_INCREMENT.getValue();
        }
        return result;
    }

    public static Collection<DatabasePacket<?>> buildUpdateResponsePackets(UpdateResponseHeader updateResponseHeader) {
        return Collections.singletonList(new MySQLOKPacket(1, updateResponseHeader.getUpdateCount(), updateResponseHeader.getLastInsertId()));
    }

    public static Collection<DatabasePacket<?>> buildClientEncodingResponsePackets() {
        return Collections.singletonList(new MySQLOKPacket(1, 0L, 0L));
    }

    @Generated
    private ResponsePacketBuilder() {
    }
}

