/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.admin.initdb;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.initdb.MySQLComInitDbPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class MySQLComInitDbExecutor
implements CommandExecutor {
    private final MySQLComInitDbPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket<?>> execute() {
        String databaseName = SQLUtil.getExactlyValue((String)this.packet.getSchema());
        if (ProxyContext.getInstance().databaseExists(databaseName) && SQLCheckEngine.check((String)databaseName, this.getRules(databaseName), (Grantee)this.connectionSession.getGrantee())) {
            this.connectionSession.setCurrentDatabase(this.packet.getSchema());
            return Collections.singletonList(new MySQLOKPacket(1));
        }
        throw new UnknownDatabaseException(this.packet.getSchema());
    }

    private Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    public MySQLComInitDbExecutor(MySQLComInitDbPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

