/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthPluginData;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLAuthenticator;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLNativePasswordAuthenticator;

public final class MySQLAuthenticationHandler {
    private final MySQLAuthPluginData authPluginData = new MySQLAuthPluginData();

    public Optional<MySQLServerErrorCode> login(String username, String hostname, byte[] authenticationResponse, String databaseName) {
        Grantee grantee = new Grantee(username, hostname);
        Collection rules = ProxyContext.getInstance().getRules(databaseName);
        MySQLAuthenticator authenticator = this.getAuthenticator(username, hostname);
        if (!SQLCheckEngine.check((Grantee)grantee, (a, b) -> authenticator.authenticate((ShardingSphereUser)a, (byte[])b), (Object)authenticationResponse, (Collection)rules)) {
            return Optional.of(MySQLServerErrorCode.ER_ACCESS_DENIED_ERROR);
        }
        return null == databaseName || SQLCheckEngine.check((String)databaseName, (Collection)rules, (Grantee)grantee) ? Optional.empty() : Optional.of(MySQLServerErrorCode.ER_DBACCESS_DENIED_ERROR);
    }

    public MySQLAuthenticator getAuthenticator(String username, String hostname) {
        return new MySQLNativePasswordAuthenticator(this.authPluginData);
    }

    @Generated
    public MySQLAuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

