/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCapabilityFlag;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConnectionPhase;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerErrorCode;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchRequestPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLAuthSwitchResponsePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.handshake.MySQLHandshakeResponse41Packet;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResult;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResultBuilder;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.MySQLAuthenticationHandler;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLAuthenticator;

public final class MySQLAuthenticationEngine
implements AuthenticationEngine {
    private final MySQLAuthenticationHandler authenticationHandler = new MySQLAuthenticationHandler();
    private MySQLConnectionPhase connectionPhase = MySQLConnectionPhase.INITIAL_HANDSHAKE;
    private int sequenceId;
    private byte[] authResponse;
    private AuthenticationResult currentAuthResult;

    public int handshake(ChannelHandlerContext context) {
        int result = ConnectionIdGenerator.getInstance().nextId();
        this.connectionPhase = MySQLConnectionPhase.AUTH_PHASE_FAST_PATH;
        context.writeAndFlush((Object)new MySQLHandshakePacket(result, this.authenticationHandler.getAuthPluginData()));
        MySQLPreparedStatementRegistry.getInstance().registerConnection(result);
        return result;
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        MySQLOKPacket mySQLOKPacket;
        Optional<MySQLServerErrorCode> errorCode;
        if (MySQLConnectionPhase.AUTH_PHASE_FAST_PATH == this.connectionPhase) {
            this.currentAuthResult = this.authPhaseFastPath(context, payload);
            if (!this.currentAuthResult.isFinished()) {
                return this.currentAuthResult;
            }
        } else if (MySQLConnectionPhase.AUTHENTICATION_METHOD_MISMATCH == this.connectionPhase) {
            this.authenticationMethodMismatch((MySQLPacketPayload)payload);
        }
        if ((errorCode = this.authenticationHandler.login(this.currentAuthResult.getUsername(), this.getHostAddress(context), this.authResponse, this.currentAuthResult.getDatabase())).isPresent()) {
            mySQLOKPacket = this.createErrorPacket(errorCode.get(), context);
        } else {
            MySQLOKPacket mySQLOKPacket2 = new MySQLOKPacket(++this.sequenceId);
            mySQLOKPacket = mySQLOKPacket2;
        }
        context.writeAndFlush((Object)mySQLOKPacket);
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)this.getHostAddress(context), (String)this.currentAuthResult.getDatabase());
    }

    private AuthenticationResult authPhaseFastPath(ChannelHandlerContext context, PacketPayload payload) {
        MySQLHandshakeResponse41Packet packet = new MySQLHandshakeResponse41Packet((MySQLPacketPayload)payload);
        this.authResponse = packet.getAuthResponse();
        this.sequenceId = packet.getSequenceId();
        MySQLCharacterSet mySQLCharacterSet = MySQLCharacterSet.findById((int)packet.getCharacterSet());
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)mySQLCharacterSet.getCharset());
        context.channel().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).set((Object)mySQLCharacterSet);
        if (!Strings.isNullOrEmpty((String)packet.getDatabase()) && !ProxyContext.getInstance().databaseExists(packet.getDatabase())) {
            context.writeAndFlush((Object)new MySQLErrPacket(++this.sequenceId, (SQLErrorCode)MySQLServerErrorCode.ER_BAD_DB_ERROR, new Object[]{packet.getDatabase()}));
            return AuthenticationResultBuilder.continued();
        }
        MySQLAuthenticator authenticator = this.authenticationHandler.getAuthenticator(packet.getUsername(), this.getHostAddress(context));
        if (this.isClientPluginAuth(packet) && !authenticator.getAuthenticationMethodName().equals(packet.getAuthPluginName())) {
            this.connectionPhase = MySQLConnectionPhase.AUTHENTICATION_METHOD_MISMATCH;
            context.writeAndFlush((Object)new MySQLAuthSwitchRequestPacket(++this.sequenceId, authenticator.getAuthenticationMethodName(), this.authenticationHandler.getAuthPluginData()));
            return AuthenticationResultBuilder.continued((String)packet.getUsername(), (String)this.getHostAddress(context), (String)packet.getDatabase());
        }
        return AuthenticationResultBuilder.finished((String)packet.getUsername(), (String)this.getHostAddress(context), (String)packet.getDatabase());
    }

    private boolean isClientPluginAuth(MySQLHandshakeResponse41Packet packet) {
        return 0 != (packet.getCapabilityFlags() & MySQLCapabilityFlag.CLIENT_PLUGIN_AUTH.getValue());
    }

    private void authenticationMethodMismatch(MySQLPacketPayload payload) {
        MySQLAuthSwitchResponsePacket packet = new MySQLAuthSwitchResponsePacket(payload);
        this.sequenceId = packet.getSequenceId();
        this.authResponse = packet.getAuthPluginResponse();
    }

    private MySQLErrPacket createErrorPacket(MySQLServerErrorCode errorCode, ChannelHandlerContext context) {
        MySQLErrPacket mySQLErrPacket;
        if (MySQLServerErrorCode.ER_DBACCESS_DENIED_ERROR == errorCode) {
            MySQLErrPacket mySQLErrPacket2 = new MySQLErrPacket(++this.sequenceId, (SQLErrorCode)MySQLServerErrorCode.ER_DBACCESS_DENIED_ERROR, new Object[]{this.currentAuthResult.getUsername(), this.getHostAddress(context), this.currentAuthResult.getDatabase()});
            mySQLErrPacket = mySQLErrPacket2;
        } else {
            MySQLErrPacket mySQLErrPacket3 = new MySQLErrPacket(++this.sequenceId, (SQLErrorCode)MySQLServerErrorCode.ER_ACCESS_DENIED_ERROR, new Object[]{this.currentAuthResult.getUsername(), this.getHostAddress(context), this.getErrorMessage()});
            mySQLErrPacket = mySQLErrPacket3;
        }
        return mySQLErrPacket;
    }

    private String getErrorMessage() {
        return 0 == this.authResponse.length ? "NO" : "YES";
    }

    private String getHostAddress(ChannelHandlerContext context) {
        SocketAddress socketAddress = context.channel().remoteAddress();
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress().getHostAddress() : socketAddress.toString();
    }
}

