/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.codec.MySQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerInfo;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLPreparedStatementRegistry;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.context.FrontendContext;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.MySQLAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class MySQLFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final FrontendContext frontendContext = new FrontendContext(false);
    private final AuthenticationEngine authenticationEngine = new MySQLAuthenticationEngine();
    private final CommandExecuteEngine commandExecuteEngine = new MySQLCommandExecuteEngine();
    private final DatabasePacketCodecEngine<MySQLPacket> codecEngine = new MySQLPacketCodecEngine();

    public MySQLFrontendEngine() {
        MySQLServerInfo.setDefualtMysqlVersion((String)((String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_MYSQL_DEFAULT_VERSION)));
    }

    public void setDatabaseVersion(String databaseName, String databaseVersion) {
        MySQLServerInfo.setServerVersion((String)databaseName, (String)databaseVersion);
    }

    public void release(ConnectionSession connectionSession) {
        MySQLPreparedStatementRegistry.getInstance().unregisterConnection(connectionSession.getConnectionId());
    }

    public void handleException(ConnectionSession connectionSession) {
    }

    public String getType() {
        return "MySQL";
    }

    @Generated
    public FrontendContext getFrontendContext() {
        return this.frontendContext;
    }

    @Generated
    public AuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public CommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public DatabasePacketCodecEngine<MySQLPacket> getCodecEngine() {
        return this.codecEngine;
    }
}

