/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class MySQLMultiStatementsHandler
implements TextProtocolBackendHandler {
    private static final Pattern MULTI_UPDATE_STATEMENTS = Pattern.compile(";(?=\\s*update)", 2);
    private static final Pattern MULTI_DELETE_STATEMENTS = Pattern.compile(";(?=\\s*delete)", 2);
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final JDBCExecutor jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), false);
    private final ConnectionSession connectionSession;
    private final SQLStatement sqlStatementSample;
    private final MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
    private final Map<String, List<ExecutionUnit>> dataSourcesToExecutionUnits = new HashMap<String, List<ExecutionUnit>>();
    private ExecutionContext anyExecutionContext;

    public MySQLMultiStatementsHandler(ConnectionSession connectionSession, SQLStatement sqlStatementSample, String sql) {
        this.connectionSession = connectionSession;
        this.sqlStatementSample = sqlStatementSample;
        Pattern pattern = sqlStatementSample instanceof UpdateStatement ? MULTI_UPDATE_STATEMENTS : MULTI_DELETE_STATEMENTS;
        ShardingSphereSQLParserEngine sqlParserEngine = this.getSQLParserEngine();
        for (String each : this.extractMultiStatements(pattern, sql)) {
            SQLStatement eachSQLStatement = sqlParserEngine.parse(each, false);
            ExecutionContext executionContext = this.createExecutionContext(this.createLogicSQL(each, eachSQLStatement));
            if (null == this.anyExecutionContext) {
                this.anyExecutionContext = executionContext;
            }
            for (ExecutionUnit eachExecutionUnit : executionContext.getExecutionUnits()) {
                this.dataSourcesToExecutionUnits.computeIfAbsent(eachExecutionUnit.getDataSourceName(), unused -> new LinkedList()).add(eachExecutionUnit);
            }
        }
    }

    private ShardingSphereSQLParserEngine getSQLParserEngine() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        return new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getResource().getDatabaseType()), ((SQLParserRule)metaDataContexts.getGlobalRuleMetaData().findSingleRule(SQLParserRule.class).orElseThrow(() -> new IllegalStateException("SQLParserRule not found"))).toParserConfiguration());
    }

    private List<String> extractMultiStatements(Pattern pattern, String sql) {
        return Arrays.asList(pattern.split(sql));
    }

    private LogicSQL createLogicSQL(String sql, SQLStatement sqlStatement) {
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaDataMap(), Collections.emptyList(), (SQLStatement)sqlStatement, (String)this.connectionSession.getSchemaName());
        return new LogicSQL(sqlStatementContext, sql, Collections.emptyList());
    }

    private ExecutionContext createExecutionContext(LogicSQL logicSQL) {
        SQLCheckEngine.check((SQLStatement)logicSQL.getSqlStatementContext().getSqlStatement(), (List)logicSQL.getParameters(), (Collection)this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getRuleMetaData().getRules(), (String)this.connectionSession.getSchemaName(), (Map)this.metaDataContexts.getMetaDataMap(), null);
        return this.kernelProcessor.generateExecutionContext(logicSQL, this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()), this.metaDataContexts.getProps());
    }

    public ResponseHeader execute() throws SQLException {
        Collection rules = this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getRuleMetaData().getRules();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.STATEMENT", ((Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), (ExecutorConnectionManager)((JDBCBackendConnection)this.connectionSession.getBackendConnection()), (ExecutorStatementManager)((JDBCBackendStatement)this.connectionSession.getStatementManager()), (StorageResourceOption)new StatementOption(false), rules);
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(this.anyExecutionContext.getRouteContext(), this.samplingExecutionUnit());
        for (ExecutionGroup eachGroup : executionGroupContext.getInputGroups()) {
            for (JDBCExecutionUnit each : eachGroup.getInputs()) {
                this.prepareBatchedStatement(each);
            }
        }
        return this.executeBatchedStatements((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext);
    }

    private Collection<ExecutionUnit> samplingExecutionUnit() {
        ArrayList<ExecutionUnit> result = new ArrayList<ExecutionUnit>(this.dataSourcesToExecutionUnits.size());
        for (List<ExecutionUnit> each : this.dataSourcesToExecutionUnits.values()) {
            result.add(each.get(0));
        }
        return result;
    }

    private void prepareBatchedStatement(JDBCExecutionUnit each) throws SQLException {
        Statement statement = each.getStorageResource();
        for (ExecutionUnit eachExecutionUnit : this.dataSourcesToExecutionUnits.get(each.getExecutionUnit().getDataSourceName())) {
            statement.addBatch(eachExecutionUnit.getSqlUnit().getSql());
        }
    }

    private UpdateResponseHeader executeBatchedStatements(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        DatabaseType databaseType = this.metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getResource().getDatabaseType();
        BatchedJDBCExecutorCallback callback = new BatchedJDBCExecutorCallback(databaseType, this.sqlStatementSample, isExceptionThrown);
        List executeResults = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
        int updated = 0;
        Iterator iterator = executeResults.iterator();
        while (iterator.hasNext()) {
            int[] eachResult;
            for (int each : eachResult = (int[])iterator.next()) {
                updated += each;
            }
        }
        return new UpdateResponseHeader(this.sqlStatementSample, Collections.singletonList(new UpdateResult(updated, 0L)));
    }

    private static class BatchedJDBCExecutorCallback
    extends JDBCExecutorCallback<int[]> {
        BatchedJDBCExecutorCallback(DatabaseType databaseType, SQLStatement sqlStatement, boolean isExceptionThrown) {
            super(databaseType, sqlStatement, isExceptionThrown);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
            try {
                int[] nArray = statement.executeBatch();
                return nArray;
            }
            finally {
                statement.close();
            }
        }

        protected Optional<int[]> getSaneResult(SQLStatement sqlStatement) {
            return Optional.empty();
        }
    }
}

