/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.MySQLColumnDefinition41Packet;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLPreparedStatementRegistry;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPrepareOKPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPreparePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.prepare.MySQLComStmtPrepareChecker;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLComStmtPrepareExecutor
implements CommandExecutor {
    private final MySQLComStmtPreparePacket packet;
    private final ConnectionSession connectionSession;
    private final int characterSet;
    private int currentSequenceId;

    public MySQLComStmtPrepareExecutor(MySQLComStmtPreparePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    public Collection<DatabasePacket<?>> execute() {
        this.failedIfContainsMultiStatements();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional sqlParserRule = metaDataContexts.getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        ShardingSphereSQLParserEngine sqlStatementParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(this.connectionSession.getSchemaName()).getResource().getDatabaseType()), ((SQLParserRule)sqlParserRule.get()).toParserConfiguration());
        SQLStatement sqlStatement = sqlStatementParserEngine.parse(this.packet.getSql(), true);
        if (!MySQLComStmtPrepareChecker.isStatementAllowed(sqlStatement)) {
            throw new UnsupportedPreparedStatementException();
        }
        int parameterCount = sqlStatement.getParameterCount();
        int projectionCount = this.getProjectionCount(sqlStatement);
        int statementId = MySQLPreparedStatementRegistry.getInstance().getConnectionPreparedStatements(this.connectionSession.getConnectionId()).prepareStatement(this.packet.getSql(), parameterCount);
        return this.createPackets(statementId, projectionCount, parameterCount);
    }

    private void failedIfContainsMultiStatements() {
        if (this.connectionSession.getAttributeMap().hasAttr(MySQLConstants.MYSQL_OPTION_MULTI_STATEMENTS) && 0 == (Integer)this.connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_OPTION_MULTI_STATEMENTS).get() && this.packet.getSql().contains(";")) {
            throw new UnsupportedPreparedStatementException();
        }
    }

    private int getProjectionCount(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            Map metaDataMap = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap();
            String schemaName = this.connectionSession.getSchemaName();
            SelectStatementContext sqlStatementContext = (SelectStatementContext)SQLStatementContextFactory.newInstance((Map)metaDataMap, (SQLStatement)sqlStatement, (String)schemaName);
            return sqlStatementContext.getProjectionsContext().getExpandProjections().size();
        }
        return 0;
    }

    private Collection<DatabasePacket<?>> createPackets(int statementId, int projectionCount, int parameterCount) {
        LinkedList result = new LinkedList();
        result.add((DatabasePacket<?>)new MySQLComStmtPrepareOKPacket(++this.currentSequenceId, statementId, projectionCount, parameterCount, 0));
        if (parameterCount > 0) {
            result.addAll(this.createParameterColumnDefinition41Packets(parameterCount));
        }
        if (projectionCount > 0) {
            result.addAll(this.createProjectionColumnDefinition41Packets(projectionCount));
        }
        return result;
    }

    private Collection<DatabasePacket<?>> createParameterColumnDefinition41Packets(int parameterCount) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < parameterCount; ++i) {
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, "", "", "", "?", "", 0, MySQLBinaryColumnType.MYSQL_TYPE_VAR_STRING, 0, false));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
        return result;
    }

    private Collection<DatabasePacket<?>> createProjectionColumnDefinition41Packets(int projectionCount) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < projectionCount; ++i) {
            result.add((DatabasePacket<?>)new MySQLColumnDefinition41Packet(++this.currentSequenceId, this.characterSet, "", "", "", "", "", 0, MySQLBinaryColumnType.MYSQL_TYPE_VAR_STRING, 0, false));
        }
        result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId));
        return result;
    }
}

