/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketTypeLoader;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.MySQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.mysql.err.MySQLErrPacketFactory;

public final class MySQLCommandExecuteEngine
implements CommandExecuteEngine {
    public MySQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return MySQLCommandPacketTypeLoader.getCommandPacketType((MySQLPacketPayload)((MySQLPacketPayload)payload));
    }

    public MySQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, ConnectionSession connectionSession) throws SQLException {
        return MySQLCommandPacketFactory.newInstance((MySQLCommandPacketType)((MySQLCommandPacketType)type), (MySQLPacketPayload)((MySQLPacketPayload)payload), (int)connectionSession.getConnectionId());
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, ConnectionSession connectionSession) throws SQLException {
        return MySQLCommandExecutorFactory.newInstance((MySQLCommandPacketType)type, packet, connectionSession);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause) {
        return MySQLErrPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket<?>> getOtherPacket(ConnectionSession connectionSession) {
        return Optional.empty();
    }

    public void writeQueryData(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY != queryCommandExecutor.getResponseType() || !context.channel().isActive()) {
            return;
        }
        int count = 0;
        int flushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        int currentSequenceId = 0;
        while (queryCommandExecutor.next()) {
            ++count;
            while (!context.channel().isWritable() && context.channel().isActive()) {
                context.flush();
                ((JDBCBackendConnection)backendConnection).getResourceLock().doAwait();
            }
            DatabasePacket dataValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)dataValue);
            if (flushThreshold == count) {
                context.flush();
                count = 0;
            }
            ++currentSequenceId;
        }
        context.write((Object)new MySQLEofPacket(++currentSequenceId + headerPackagesCount));
    }
}

