/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.state.impl;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecutorTask;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.executor.UserExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.impl.OKProxyState;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class JDBCOKProxyState
implements OKProxyState {
    @Override
    public void execute(ChannelHandlerContext context, Object message, DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, ConnectionSession connectionSession) {
        CommandExecutorTask commandExecutorTask = new CommandExecutorTask(databaseProtocolFrontendEngine, connectionSession, context, message);
        ExecutorService executorService = this.determineSuitableExecutorService(context, databaseProtocolFrontendEngine, connectionSession);
        executorService.execute(commandExecutorTask);
    }

    private ExecutorService determineSuitableExecutorService(ChannelHandlerContext context, DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, ConnectionSession connectionSession) {
        if (this.requireOccupyThreadForConnection(connectionSession)) {
            return ConnectionThreadExecutorGroup.getInstance().get(connectionSession.getConnectionId());
        }
        if (this.isPreferNettyEventLoop()) {
            return context.executor();
        }
        if (databaseProtocolFrontendEngine.getFrontendContext().isRequiredSameThreadForConnection()) {
            return ConnectionThreadExecutorGroup.getInstance().get(connectionSession.getConnectionId());
        }
        return UserExecutorGroup.getInstance().getExecutorService();
    }

    private boolean requireOccupyThreadForConnection(ConnectionSession connectionSession) {
        return (Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_HINT_ENABLED) != false || TransactionType.isDistributedTransaction((TransactionType)connectionSession.getTransactionStatus().getTransactionType());
    }

    private boolean isPreferNettyEventLoop() {
        switch ((String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_EXECUTOR_SUITABLE)) {
            case "OLTP": {
                return true;
            }
            case "OLAP": {
                return false;
            }
        }
        throw new IllegalArgumentException("The property proxy-backend-executor-suitable must be 'OLAP' or 'OLTP'");
    }

    public String getType() {
        return "JDBC";
    }
}

