/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeMap;
import java.nio.charset.Charset;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationResult;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.ProxyStateContext;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FrontendChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrontendChannelInboundHandler.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final ConnectionSession connectionSession;
    private volatile boolean authenticated;

    public FrontendChannelInboundHandler(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, Channel channel) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.connectionSession = new ConnectionSession(DatabaseTypeFactory.getInstance((String)databaseProtocolFrontendEngine.getType()), this.getTransactionRule().getDefaultType(), (AttributeMap)channel);
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    public void channelActive(ChannelHandlerContext context) {
        int connectionId = this.databaseProtocolFrontendEngine.getAuthenticationEngine().handshake(context);
        ConnectionThreadExecutorGroup.getInstance().register(connectionId);
        this.connectionSession.setConnectionId(connectionId);
    }

    public void channelRead(ChannelHandlerContext context, Object message) {
        if (!this.authenticated) {
            this.authenticated = this.authenticate(context, (ByteBuf)message);
            return;
        }
        ProxyStateContext.execute(context, message, this.databaseProtocolFrontendEngine, this.connectionSession);
    }

    private boolean authenticate(ChannelHandlerContext context, ByteBuf message) {
        boolean bl;
        block9: {
            PacketPayload payload = this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload(message, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
            try {
                AuthenticationResult authResult = this.databaseProtocolFrontendEngine.getAuthenticationEngine().authenticate(context, payload);
                if (authResult.isFinished()) {
                    this.connectionSession.setGrantee(new Grantee(authResult.getUsername(), authResult.getHostname()));
                    this.connectionSession.setCurrentDatabase(authResult.getDatabase());
                }
                bl = authResult.isFinished();
                if (payload == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (payload != null) {
                        try {
                            payload.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    log.error("Exception occur: ", (Throwable)ex);
                    context.writeAndFlush((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(ex));
                    context.close();
                    return false;
                }
            }
            payload.close();
        }
        return bl;
    }

    public void channelInactive(ChannelHandlerContext context) {
        context.fireChannelInactive();
        this.closeAllResources();
    }

    private void closeAllResources() {
        ConnectionThreadExecutorGroup.getInstance().unregisterAndAwaitTermination(this.connectionSession.getConnectionId());
        try {
            this.connectionSession.getBackendConnection().closeAllResources();
        }
        catch (BackendConnectionException ex) {
            log.error("Exception occurred when frontend connection [{}] disconnected", (Object)this.connectionSession.getConnectionId(), (Object)ex);
        }
        this.databaseProtocolFrontendEngine.release(this.connectionSession);
    }

    public void channelWritabilityChanged(ChannelHandlerContext context) {
        if (context.channel().isWritable()) {
            ((JDBCBackendConnection)this.connectionSession.getBackendConnection()).getResourceLock().doNotify();
        }
    }
}

