/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class ConnectionThreadExecutorGroup {
    private static final ConnectionThreadExecutorGroup INSTANCE = new ConnectionThreadExecutorGroup();
    private final Map<Integer, ExecutorService> executorServices = new ConcurrentHashMap<Integer, ExecutorService>();

    public static ConnectionThreadExecutorGroup getInstance() {
        return INSTANCE;
    }

    public void register(int connectionId) {
        this.executorServices.put(connectionId, this.newSingleThreadExecutorService(connectionId));
    }

    private ExecutorService newSingleThreadExecutorService(int connectionId) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> new Thread(runnable, String.format("Connection-%d-ThreadExecutor", connectionId)));
    }

    public ExecutorService get(int connectionId) {
        return this.executorServices.get(connectionId);
    }

    public void unregisterAndAwaitTermination(int connectionId) {
        ExecutorService executorService = this.executorServices.remove(connectionId);
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    private ConnectionThreadExecutorGroup() {
    }
}

