/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.command;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementDatabaseHolder;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.exception.ExpectedExceptions;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class CommandExecutorTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandExecutorTask.class);
    private final DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine;
    private final ConnectionSession connectionSession;
    private final ChannelHandlerContext context;
    private final Object message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isNeedFlush = false;
        boolean sqlShowEnabled = (Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.SQL_SHOW);
        try (PacketPayload payload = this.databaseProtocolFrontendEngine.getCodecEngine().createPacketPayload((ByteBuf)this.message, (Charset)this.context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());){
            if (sqlShowEnabled) {
                this.fillLogMDC();
            }
            this.connectionSession.getBackendConnection().prepareForTaskExecution();
            isNeedFlush = this.executeCommand(this.context, payload);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        finally {
            SQLStatementDatabaseHolder.remove();
            Collection<SQLException> exceptions = Collections.emptyList();
            try {
                this.connectionSession.getBackendConnection().closeExecutionResources();
            }
            catch (BackendConnectionException ex) {
                exceptions = ex.getExceptions().stream().filter(SQLException.class::isInstance).map(SQLException.class::cast).collect(Collectors.toList());
            }
            if (isNeedFlush) {
                this.context.flush();
            }
            this.processClosedExceptions(exceptions);
            if (sqlShowEnabled) {
                this.clearLogMDC();
            }
        }
    }

    private boolean executeCommand(ChannelHandlerContext context, PacketPayload payload) throws SQLException {
        CommandExecuteEngine commandExecuteEngine = this.databaseProtocolFrontendEngine.getCommandExecuteEngine();
        CommandPacketType type = commandExecuteEngine.getCommandPacketType(payload);
        CommandPacket commandPacket = commandExecuteEngine.getCommandPacket(payload, type, this.connectionSession);
        try (CommandExecutor commandExecutor = commandExecuteEngine.getCommandExecutor(type, commandPacket, this.connectionSession);){
            Collection responsePackets = commandExecutor.execute();
            if (responsePackets.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            responsePackets.forEach(arg_0 -> ((ChannelHandlerContext)context).write(arg_0));
            if (commandExecutor instanceof QueryCommandExecutor) {
                commandExecuteEngine.writeQueryData(context, this.connectionSession.getBackendConnection(), (QueryCommandExecutor)commandExecutor, responsePackets.size());
            }
            boolean bl = true;
            return bl;
        }
    }

    private void processException(Exception cause) {
        if (!ExpectedExceptions.isExpected(cause.getClass())) {
            log.error("Exception occur: ", (Throwable)cause);
        }
        this.context.write((Object)this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getErrorPacket(cause));
        Optional databasePacket = this.databaseProtocolFrontendEngine.getCommandExecuteEngine().getOtherPacket(this.connectionSession);
        databasePacket.ifPresent(arg_0 -> ((ChannelHandlerContext)this.context).write(arg_0));
        this.context.flush();
    }

    private void processClosedExceptions(Collection<SQLException> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        this.processException(ex);
    }

    private void fillLogMDC() {
        MDC.put((String)"database", (String)this.connectionSession.getDatabaseName());
        MDC.put((String)"user", (String)this.connectionSession.getGrantee().toString());
    }

    private void clearLogMDC() {
        MDC.clear();
    }

    @Generated
    public CommandExecutorTask(DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, ConnectionSession connectionSession, ChannelHandlerContext context, Object message) {
        this.databaseProtocolFrontendEngine = databaseProtocolFrontendEngine;
        this.connectionSession = connectionSession;
        this.context = context;
        this.message = message;
    }
}

