/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendDataSource;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.netty.ServerHandlerInitializer;
import org.apache.shardingsphere.proxy.frontend.protocol.FrontDatabaseProtocolTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereProxy.class);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public void start(int port) {
        try {
            ChannelFuture future = this.startInternal(port);
            this.accept(future);
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            BackendExecutorContext.getInstance().getExecutorEngine().close();
        }
    }

    private ChannelFuture startInternal(int port) throws InterruptedException {
        this.createEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.initServerBootstrap(bootstrap);
        return bootstrap.bind(port).sync();
    }

    private void accept(ChannelFuture future) throws InterruptedException {
        log.info("ShardingSphere-Proxy {} mode started successfully", (Object)ProxyContext.getInstance().getContextManager().getInstanceContext().getModeConfiguration().getType());
        future.channel().closeFuture().sync();
    }

    private void createEventLoopGroup() {
        this.bossGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
        this.workerGroup = this.getWorkerGroup();
    }

    private EventLoopGroup getWorkerGroup() {
        String driverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        boolean reactiveBackendEnabled = "ExperimentalVertx".equalsIgnoreCase(driverType);
        if (reactiveBackendEnabled) {
            return VertxBackendDataSource.getInstance().getVertx().nettyEventLoopGroup();
        }
        int workerThreads = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_EXECUTOR_SIZE);
        return Epoll.isAvailable() ? new EpollEventLoopGroup(workerThreads) : new NioEventLoopGroup(workerThreads);
    }

    private void initServerBootstrap(ServerBootstrap bootstrap) {
        Integer backLog = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_NETTY_BACKLOG);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)backLog)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer(FrontDatabaseProtocolTypeFactory.getDatabaseType()));
    }
}

