/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnectorFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.StorageUnitNotExistedException;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class UnicastResourceShowExecutor
implements DatabaseAdminQueryExecutor {
    private final DatabaseConnectorFactory databaseConnectorFactory = DatabaseConnectorFactory.getInstance();
    private final SelectStatement sqlStatement;
    private final String sql;
    private MergedResult mergedResult;
    private DatabaseConnector databaseConnector;
    private ResponseHeader responseHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConnectionSession connectionSession) throws SQLException {
        String originDatabase = connectionSession.getDatabaseName();
        String databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        ShardingSpherePreconditions.checkState((boolean)ProxyContext.getInstance().getDatabase(databaseName).containsDataSource(), () -> new StorageUnitNotExistedException(databaseName));
        try {
            connectionSession.setCurrentDatabase(databaseName);
            SQLStatementContext sqlStatementContext = new SQLBindEngine(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), connectionSession.getDefaultDatabaseName()).bind((SQLStatement)this.sqlStatement, Collections.emptyList());
            this.databaseConnector = this.databaseConnectorFactory.newInstance(new QueryContext(sqlStatementContext, this.sql, Collections.emptyList()), connectionSession.getDatabaseConnectionManager(), false);
            this.responseHeader = this.databaseConnector.execute();
            this.mergedResult = new TransparentMergedResult(this.createQueryResult());
        }
        finally {
            connectionSession.setCurrentDatabase(originDatabase);
            this.databaseConnector.close();
        }
    }

    private String getFirstDatabaseName() {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<String> result = databaseNames.stream().filter(each -> ProxyContext.getInstance().getDatabase(each).containsDataSource()).findFirst();
        ShardingSpherePreconditions.checkState((boolean)result.isPresent(), StorageUnitNotExistedException::new);
        return result.get();
    }

    public QueryResultMetaData getQueryResultMetaData() {
        List columns = ((QueryResponseHeader)this.responseHeader).getQueryHeaders().stream().map(QueryHeader::getColumnLabel).map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 100, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    private QueryResult createQueryResult() throws SQLException {
        LinkedList<MemoryQueryResultDataRow> rows = new LinkedList<MemoryQueryResultDataRow>();
        while (this.databaseConnector.next()) {
            List data = this.databaseConnector.getRowData().getData();
            rows.add(new MemoryQueryResultDataRow(data));
        }
        return new RawMemoryQueryResult(this.getQueryResultMetaData(), rows);
    }

    @Generated
    public UnicastResourceShowExecutor(SelectStatement sqlStatement, String sql) {
        this.sqlStatement = sqlStatement;
        this.sql = sql;
    }

    @Generated
    public DatabaseConnectorFactory getDatabaseConnectorFactory() {
        return this.databaseConnectorFactory;
    }

    @Generated
    public SelectStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public DatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }

    @Generated
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }
}

